/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef THIRD_PARTY_BLINK_RENDERER_MODULES_WEBMIDI_MIDI_OUTPUT_H_
#define THIRD_PARTY_BLINK_RENDERER_MODULES_WEBMIDI_MIDI_OUTPUT_H_

#include <utility>
#include "base/time/time.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/webmidi/midi_port.h"
#include "third_party/blink/renderer/platform/heap/heap_allocator.h"

namespace blink {

class ExceptionState;
class MIDIAccess;

class MIDIOutput final : public MIDIPort {
  DEFINE_WRAPPERTYPEINFO();

 public:
  static MIDIOutput* Create(MIDIAccess*,
                            unsigned port_index,
                            const String& id,
                            const String& manufacturer,
                            const String& name,
                            const String& version,
                            midi::mojom::PortState);
  ~MIDIOutput() override;

  void send(NotShared<DOMUint8Array>, double timestamp, ExceptionState&);
  void send(Vector<unsigned>, double timestamp, ExceptionState&);

  // send() without optional |timestamp|.
  void send(NotShared<DOMUint8Array>, ExceptionState&);
  void send(Vector<unsigned>, ExceptionState&);

  void Trace(blink::Visitor*) override;

 private:
  MIDIOutput(MIDIAccess*,
             unsigned port_index,
             const String& id,
             const String& manufacturer,
             const String& name,
             const String& version,
             midi::mojom::PortState);

  void DidOpen(bool opened) override;
  void SendInternal(DOMUint8Array*, base::TimeTicks timestamp, ExceptionState&);

  unsigned port_index_;
  HeapDeque<std::pair<Member<DOMUint8Array>, base::TimeTicks>> pending_data_;
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_MODULES_WEBMIDI_MIDI_OUTPUT_H_
