//
// Copyright (c) 2014 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

#ifndef SAMPLE_UTIL_KEYBOARD_H
#define SAMPLE_UTIL_KEYBOARD_H

enum Key
{
    KEY_UNKNOWN,
    KEY_A,          // The A key
    KEY_B,          // The B key
    KEY_C,          // The C key
    KEY_D,          // The D key
    KEY_E,          // The E key
    KEY_F,          // The F key
    KEY_G,          // The G key
    KEY_H,          // The H key
    KEY_I,          // The I key
    KEY_J,          // The J key
    KEY_K,          // The K key
    KEY_L,          // The L key
    KEY_M,          // The M key
    KEY_N,          // The N key
    KEY_O,          // The O key
    KEY_P,          // The P key
    KEY_Q,          // The Q key
    KEY_R,          // The R key
    KEY_S,          // The S key
    KEY_T,          // The T key
    KEY_U,          // The U key
    KEY_V,          // The V key
    KEY_W,          // The W key
    KEY_X,          // The X key
    KEY_Y,          // The Y key
    KEY_Z,          // The Z key
    KEY_NUM0,       // The 0 key
    KEY_NUM1,       // The 1 key
    KEY_NUM2,       // The 2 key
    KEY_NUM3,       // The 3 key
    KEY_NUM4,       // The 4 key
    KEY_NUM5,       // The 5 key
    KEY_NUM6,       // The 6 key
    KEY_NUM7,       // The 7 key
    KEY_NUM8,       // The 8 key
    KEY_NUM9,       // The 9 key
    KEY_ESCAPE,     // The escape key
    KEY_LCONTROL,   // The left control key
    KEY_LSHIFT,     // The left shift key
    KEY_LALT,       // The left alt key
    KEY_LSYSTEM,    // The left OS specific key: Window (Windows and Linux), Apple (MacOS X), ...
    KEY_RCONTROL,   // The right control key
    KEY_RSHIFT,     // The right shift key
    KEY_RALT,       // The right alt key
    KEY_RSYSTEM,    // The right OS specific key: Window (Windows and Linux), Apple (MacOS X), ...
    KEY_MENU,       // The menu key
    KEY_LBRACKET,   // The [ key
    KEY_RBRACKET,   // The ] key
    KEY_SEMICOLON,  // The ; key
    KEY_COMMA,      // The , key
    KEY_PERIOD,     // The . key
    KEY_QUOTE,      // The ' key
    KEY_SLASH,      // The / key
    KEY_BACKSLASH,  // The \ key
    KEY_TILDE,      // The ~ key
    KEY_EQUAL,      // The = key
    KEY_DASH,       // The - key
    KEY_SPACE,      // The space key
    KEY_RETURN,     // The return key
    KEY_BACK,       // The backspace key
    KEY_TAB,        // The tabulation key
    KEY_PAGEUP,     // The page up key
    KEY_PAGEDOWN,   // The page down key
    KEY_END,        // The end key
    KEY_HOME,       // The home key
    KEY_INSERT,     // The insert key
    KEY_DELETE,     // The delete key
    KEY_ADD,        // +
    KEY_SUBTRACT,   // -
    KEY_MULTIPLY,   // *
    KEY_DIVIDE,     // /
    KEY_LEFT,       // Left arrow
    KEY_RIGHT,      // Right arrow
    KEY_UP,         // Up arrow
    KEY_DOWN,       // Down arrow
    KEY_NUMPAD0,    // The numpad 0 key
    KEY_NUMPAD1,    // The numpad 1 key
    KEY_NUMPAD2,    // The numpad 2 key
    KEY_NUMPAD3,    // The numpad 3 key
    KEY_NUMPAD4,    // The numpad 4 key
    KEY_NUMPAD5,    // The numpad 5 key
    KEY_NUMPAD6,    // The numpad 6 key
    KEY_NUMPAD7,    // The numpad 7 key
    KEY_NUMPAD8,    // The numpad 8 key
    KEY_NUMPAD9,    // The numpad 9 key
    KEY_F1,         // The F1 key
    KEY_F2,         // The F2 key
    KEY_F3,         // The F3 key
    KEY_F4,         // The F4 key
    KEY_F5,         // The F5 key
    KEY_F6,         // The F6 key
    KEY_F7,         // The F7 key
    KEY_F8,         // The F8 key
    KEY_F9,         // The F8 key
    KEY_F10,        // The F10 key
    KEY_F11,        // The F11 key
    KEY_F12,        // The F12 key
    KEY_F13,        // The F13 key
    KEY_F14,        // The F14 key
    KEY_F15,        // The F15 key
    KEY_PAUSE,      // The pause key
    KEY_COUNT,
};

#endif  // SAMPLE_UTIL_KEYBOARD_H
