// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/resources/grit/blink_resources.h"
#include "third_party/blink/renderer/core/script/layered_api_module.h"

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_SCRIPT_LAYERED_API_RESOURCES_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_SCRIPT_LAYERED_API_RESOURCES_H_

// This file is generated by
// core/script/generate_lapi_grdp.py and shouldn't modified manually.
// A corresponding grdp file (layered_api_resources.grdp) is also generated.

// This file should be included only once from core/script/layered_api.cc.

namespace blink {

namespace layered_api {

namespace {

struct LayeredAPIResource {
  const char* path;
  int resource_id;
  Module module;
};

const LayeredAPIResource kLayeredAPIResources[] = {
    {"blank/index.mjs", IDR_LAYERED_API_BLANK_INDEX_MJS, Module::kBlank},

    {"elements/internal/reflection.mjs",
     IDR_LAYERED_API_ELEMENTS_INTERNAL_REFLECTION_MJS,
     Module::kElementsInternal},

    {"elements/switch/face_utils.mjs",
     IDR_LAYERED_API_ELEMENTS_SWITCH_FACE_UTILS_MJS, Module::kElementsSwitch},
    {"elements/switch/index.mjs", IDR_LAYERED_API_ELEMENTS_SWITCH_INDEX_MJS,
     Module::kElementsSwitch},
    {"elements/switch/style.mjs", IDR_LAYERED_API_ELEMENTS_SWITCH_STYLE_MJS,
     Module::kElementsSwitch},
    {"elements/switch/track.mjs", IDR_LAYERED_API_ELEMENTS_SWITCH_TRACK_MJS,
     Module::kElementsSwitch},

    {"elements/toast/index.mjs", IDR_LAYERED_API_ELEMENTS_TOAST_INDEX_MJS,
     Module::kElementsToast},

    {"elements/virtual-scroller/find-element.mjs",
     IDR_LAYERED_API_ELEMENTS_VIRTUAL_SCROLLER_FIND_ELEMENT_MJS,
     Module::kElementsVirtualScroller},
    {"elements/virtual-scroller/index.mjs",
     IDR_LAYERED_API_ELEMENTS_VIRTUAL_SCROLLER_INDEX_MJS,
     Module::kElementsVirtualScroller},
    {"elements/virtual-scroller/sets.mjs",
     IDR_LAYERED_API_ELEMENTS_VIRTUAL_SCROLLER_SETS_MJS,
     Module::kElementsVirtualScroller},
    {"elements/virtual-scroller/visibility-manager.mjs",
     IDR_LAYERED_API_ELEMENTS_VIRTUAL_SCROLLER_VISIBILITY_MANAGER_MJS,
     Module::kElementsVirtualScroller},

    {"kv-storage/async_iterator.mjs",
     IDR_LAYERED_API_KV_STORAGE_ASYNC_ITERATOR_MJS, Module::kKvStorage},
    {"kv-storage/idb_utils.mjs", IDR_LAYERED_API_KV_STORAGE_IDB_UTILS_MJS,
     Module::kKvStorage},
    {"kv-storage/index.mjs", IDR_LAYERED_API_KV_STORAGE_INDEX_MJS,
     Module::kKvStorage},

};

}  // namespace

}  // namespace layered_api

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_SCRIPT_LAYERED_API_RESOURCES_H_
