/****************************************************************************
**
** Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia. For licensing terms and
** conditions see http://qt.digia.com/licensing. For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights. These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
**
** This file was generated by glgen version 0.1
** Command line was: glgen
**
** glgen is Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
**
** This is an auto-generated file.
** Do not edit! All changes made to it will be lost.
**
****************************************************************************/

#include "qopenglversionfunctionsfactory_p.h"

#if !defined(QT_OPENGL_ES_2)
#include "qopenglfunctions_4_3_core.h"
#include "qopenglfunctions_4_3_compatibility.h"
#include "qopenglfunctions_4_2_core.h"
#include "qopenglfunctions_4_2_compatibility.h"
#include "qopenglfunctions_4_1_core.h"
#include "qopenglfunctions_4_1_compatibility.h"
#include "qopenglfunctions_4_0_core.h"
#include "qopenglfunctions_4_0_compatibility.h"
#include "qopenglfunctions_3_3_core.h"
#include "qopenglfunctions_3_3_compatibility.h"
#include "qopenglfunctions_3_2_core.h"
#include "qopenglfunctions_3_2_compatibility.h"
#include "qopenglfunctions_3_1.h"
#include "qopenglfunctions_3_0.h"
#include "qopenglfunctions_2_1.h"
#include "qopenglfunctions_2_0.h"
#include "qopenglfunctions_1_5.h"
#include "qopenglfunctions_1_4.h"
#include "qopenglfunctions_1_3.h"
#include "qopenglfunctions_1_2.h"
#include "qopenglfunctions_1_1.h"
#include "qopenglfunctions_1_0.h"
#else
#include "qopenglfunctions_es2.h"
#endif

QT_BEGIN_NAMESPACE

QAbstractOpenGLFunctions *QOpenGLVersionFunctionsFactory::create(const QOpenGLVersionProfile &versionProfile)
{
#if !defined(QT_OPENGL_ES_2)
    const int major = versionProfile.version().first;
    const int minor = versionProfile.version().second;

    if (versionProfile.hasProfiles()) {
        switch (versionProfile.profile()) {
        case QSurfaceFormat::CoreProfile:
            if (major == 4 && minor == 3)
                return new QOpenGLFunctions_4_3_Core;
            else if (major == 4 && minor == 2)
                return new QOpenGLFunctions_4_2_Core;
            else if (major == 4 && minor == 1)
                return new QOpenGLFunctions_4_1_Core;
            else if (major == 4 && minor == 0)
                return new QOpenGLFunctions_4_0_Core;
            else if (major == 3 && minor == 3)
                return new QOpenGLFunctions_3_3_Core;
            else if (major == 3 && minor == 2)
                return new QOpenGLFunctions_3_2_Core;
            break;

        case QSurfaceFormat::CompatibilityProfile:
            if (major == 4 && minor == 3)
                return new QOpenGLFunctions_4_3_Compatibility;
            else if (major == 4 && minor == 2)
                return new QOpenGLFunctions_4_2_Compatibility;
            else if (major == 4 && minor == 1)
                return new QOpenGLFunctions_4_1_Compatibility;
            else if (major == 4 && minor == 0)
                return new QOpenGLFunctions_4_0_Compatibility;
            else if (major == 3 && minor == 3)
                return new QOpenGLFunctions_3_3_Compatibility;
            else if (major == 3 && minor == 2)
                return new QOpenGLFunctions_3_2_Compatibility;
            break;

        case QSurfaceFormat::NoProfile:
        default:
            break;
        };
    } else {
        if (major == 3 && minor == 1)
            return new QOpenGLFunctions_3_1;
        else if (major == 3 && minor == 0)
            return new QOpenGLFunctions_3_0;
        else if (major == 2 && minor == 1)
            return new QOpenGLFunctions_2_1;
        else if (major == 2 && minor == 0)
            return new QOpenGLFunctions_2_0;
        else if (major == 1 && minor == 5)
            return new QOpenGLFunctions_1_5;
        else if (major == 1 && minor == 4)
            return new QOpenGLFunctions_1_4;
        else if (major == 1 && minor == 3)
            return new QOpenGLFunctions_1_3;
        else if (major == 1 && minor == 2)
            return new QOpenGLFunctions_1_2;
        else if (major == 1 && minor == 1)
            return new QOpenGLFunctions_1_1;
        else if (major == 1 && minor == 0)
            return new QOpenGLFunctions_1_0;
    }
    return 0;
#else
    Q_UNUSED(versionProfile);
    return new QOpenGLFunctions_ES2;
#endif
}

QT_END_NAMESPACE
