/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorWrapCheck
extends AbstractOptionCheck<WrapOption> {
    public OperatorWrapCheck() {
        super(WrapOption.NL, WrapOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{111, 83, 118, 117, 129, 127, 128, 61, 130, 125, 126, 122, 120, 124, 121, 119, 115, 114, 112, 116, 113, 176, 123};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{111, 83, 118, 117, 129, 127, 128, 61, 130, 125, 126, 122, 120, 124, 121, 119, 115, 114, 112, 116, 113, 123, 176, 81, 103, 100, 101, 102, 104, 105, 106, 107, 109, 110, 108};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST parent;
        if (aAST.getType() == 83 && ((parent = aAST.getParent()).getType() == 96 || parent.getType() == 95)) {
            return;
        }
        WrapOption wOp = (WrapOption)((Object)this.getAbstractOption());
        String text = aAST.getText();
        int colNo = aAST.getColumnNo();
        int lineNo = aAST.getLineNo();
        String currentLine = this.getLines()[lineNo - 1];
        if (wOp == WrapOption.NL && !text.equals(currentLine.trim()) && currentLine.substring(colNo + text.length()).trim().length() == 0) {
            this.log(lineNo, colNo, "line.new", text);
        } else if (wOp == WrapOption.EOL && Utils.whitespaceBefore(colNo - 1, currentLine)) {
            this.log(lineNo, colNo, "line.previous", text);
        }
    }
}

