/*
 * Copyright (C) 2013, Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "public/platform/WebContentDecryptionModuleSession.h"
#include "public/platform/WebString.h"

namespace blink {

static void ReportError(WebContentDecryptionModuleResult result)
{
    result.completeWithError(WebContentDecryptionModuleExceptionUnknownError, 0, "Not implemented.");
}

WebContentDecryptionModuleSession::~WebContentDecryptionModuleSession()
{
}

WebContentDecryptionModuleSession::Client::~Client()
{
}

// FIXME: Remove the default implementations of these methods once the new
// methods are implemented in Chromium.
void WebContentDecryptionModuleSession::initializeNewSession(const WebString& initDataType, const unsigned char* initData, size_t initDataLength, const WebString& sessionType, WebContentDecryptionModuleResult result)
{
    ReportError(result);
}

void WebContentDecryptionModuleSession::load(const WebString& sessionId, WebContentDecryptionModuleResult result)
{
    ReportError(result);
}

void WebContentDecryptionModuleSession::update(const unsigned char* response, size_t responseLength, WebContentDecryptionModuleResult result)
{
    ReportError(result);
}

void WebContentDecryptionModuleSession::close(WebContentDecryptionModuleResult result)
{
    ReportError(result);
}

void WebContentDecryptionModuleSession::remove(WebContentDecryptionModuleResult result)
{
    ReportError(result);
}

void WebContentDecryptionModuleSession::release(WebContentDecryptionModuleResult result)
{
    ReportError(result);
}

} // namespace blink
