/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebFilterAnimationCurve_h
#define WebFilterAnimationCurve_h

#include "WebCompositorAnimationCurve.h"

#include "WebCommon.h"
#include "WebFilterKeyframe.h"

namespace blink {

// A keyframed filter animation curve.
class WebFilterAnimationCurve : public WebCompositorAnimationCurve {
public:
    virtual ~WebFilterAnimationCurve() { }

    virtual void add(const WebFilterKeyframe&, TimingFunctionType = TimingFunctionTypeEase) = 0;
    // Adds the keyframe with a custom, bezier timing function. Note, it is
    // assumed that x0 = y0 = 0, and x3 = y3 = 1.
    virtual void add(const WebFilterKeyframe&, double x1, double y1, double x2, double y2) = 0;
    // Adds the keyframe with a steps timing function.
    virtual void add(const WebFilterKeyframe&, int steps, float stepsStartOffset) = 0;

    virtual void setLinearTimingFunction() = 0;
    virtual void setCubicBezierTimingFunction(TimingFunctionType) = 0;
    virtual void setCubicBezierTimingFunction(double x1, double y1, double x2, double y2) = 0;
    virtual void setStepsTimingFunction(int numberOfSteps, float stepsStartOffset) = 0;
};

} // namespace blink

#endif // WebFilterAnimationCurve_h
