Linux
=====

Quickstart
----------

1.  Install depot tools.

    <!--?prettify lang=sh?-->

        git clone 'https://chromium.googlesource.com/chromium/tools/depot_tools.git'
        export PATH="${PWD}/depot_tools:${PATH}"

2.  Get Skia.

    <!--?prettify lang=sh?-->

        git clone 'https://skia.googlesource.com/skia'
        cd skia

3.  Install Dependencies (may require sudo).

    <!--?prettify lang=sh?-->

        tools/install_dependencies.sh

4.  Build.

    <!--?prettify lang=sh?-->

        bin/sync-and-gyp && ninja -C out/Debug

5.  Run DM (the Skia test app) and SampleApp.

    <!--?prettify lang=sh?-->

        out/Debug/dm
        out/Debug/SampleApp

Prerequisites
-------------

On a Ubuntu 12.04 (Precise) or Ubuntu 14.04 (Trusty) system, you can run
`tools/install_dependencies.sh`, which will install the needed packages.  On
Ubuntu 12.04, you will need to install the`ninja` build tool separately, which
comes with Chromium's `depot_tools`.

To contribute changes back to Skia, you will need `git-cl`, which comes with Chromium's `depot_tools`.

(If you use another Linux distribution, please consider contributing back
instructions for installing the required packages — we can then incorporate
that knowledge into the `tools/install_dependencies.sh` tool.)

Make sure the following have been installed:

  * Chromium depot_tools: http://www.chromium.org/developers/how-tos/depottools
  * A C++ compiler (typically gcc)
  * python 2.7.x
    * suggested Ubuntu packages: python2.7, python2.7-dev
  * The FreeType and Fontconfig font engines
    * suggested Ubuntu packages: libfreetype6, libfreetype6-dev , libfontconfig , libfontconfig-dev e.g., `sudo apt-get install libfreetype6 libfreetype6-dev libfontconfig libfontconfig-dev`
  * libpng
    * suggested Ubuntu packages: libpng12-0, libpng12-dev e.g., `sudo apt-get install libpng12-0 libpng12-dev`
  * libgif
    * suggested Ubuntu package: libgif-dev e.g., `sudo apt-get install libgif-dev`
    * `$ sudo apt-get install libgif4:i386`
    * `$ sudo ln -s /usr/lib/i386-linux-gnu/libgif.so.4 /usr/lib/i386-linux-gnu/libgif.so`
  * libglu1-mesa-dev
  * mesa-common-dev
  * GL
    * such as freeglut3-dev

Check out the source code
-------------------------

Follow the instructions [here](../download) for downloading the Skia source.


Generate build files
--------------------

We use the open-source gyp tool to generate ninja files (and analogous build
scripts on other platforms) from our multiplatform "gyp" files.

Generate the build files by running the following in your Skia home directory:

    ./gyp_skia

Or, you can just rely on it being run automatically by using `make` instead of
`ninja` in examples shown below.

If you want to use Eclipse, see Creating an Eclipse Project after you have generated the makefiles.

On 32-bit Linux (when `uname -m` is *not* `x86_64`), you will have to
explicitly specify the architecture:

    GYP_DEFINES='skia_arch_width=32' ./gyp_skia

Build and run tests from the command line
-----------------------------------------

    ninja -C out/Debug dm
    out/Debug/dm

The usual mode you want for testing is Debug mode (`SK_DEBUG` is defined, and
debug symbols are included in the binary). If you would like to build the

Release version instead
-----------------------

    ninja -C out/Release dm
    out/Release/dm

Build and run nanobench (performance tests)
-------------------------------------------

In this case, we will build with the "Release" configuration, since we are
running performance tests.

    ninja -C out/Release nanobench
    out/Release/nanobench [ --skps path/to/*.skp ]

Build and run SampleApp
-----------------------

This time we will add the `-j` flag to fire up multiple threads during the
build. (This can be used with the other targets too.)

    make -j SampleApp
    out/Debug/SampleApp

When this launches, you should see a window with various graphical examples.
To move through the sample app, use the following keypresses:

  * right-arrow key: cycle through different test pages
  * left-arrow key: cycle through rendering methods for each test page
  * other keys are defined in SampleApp.cpp’s SampleWindow::onHandleKey() and SampleWindow::onHandleChar() methods

Build and run gm ("golden master") tests
----------------------------------------

This will display the return value (0 = success) after running the tests...

    make -j gm
    out/Debug/gm -r gm/base-linux ; echo $?

You can also adjust the type used to represent SkScalar. By default, we use a
float. To change that, run it as follows:

    GYP_DEFINES="skia_scalar=fixed" make -j gm
    out/Debug/gm -r gm/base-linux-fixed ; echo $?

Build and run bench (performance testbench)
-------------------------------------------

Since bench tests performance, it usually makes more sense to run it in
Release mode...

    make -j bench BUILDTYPE=Release
    out/Release/bench

Build tools
-----------

    make -j tools
    out/Debug/skdiff

Clean up all generated files
----------------------------

    make clean
