/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.gui.FileDrop;
import com.puppycrawl.tools.checkstyle.gui.JTreeTable;
import com.puppycrawl.tools.checkstyle.gui.Main;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ParseTreeInfoPanel
extends JPanel {
    private static final long serialVersionUID = -4243405131202059043L;
    private final JTreeTable treeTable;
    private final ParseTreeModel parseTreeModel;
    private final JTextArea jTextArea;
    private File lastDirectory = null;
    private File currentFile = null;
    private final Action reloadAction;
    private final List<Integer> lines2position = new ArrayList<Integer>();

    public void openAst(DetailAST parseTree, Component parent) {
        this.parseTreeModel.setParseTree(parseTree);
        this.reloadAction.setEnabled(true);
        this.getLines2position().clear();
        this.getLines2position().add(0);
        if (this.jTextArea.getText().length() != 0) {
            this.jTextArea.replaceRange("", 0, this.jTextArea.getText().length());
        }
        this.jTextArea.moveCaretPosition(0);
    }

    public void openFile(File file, Component parent) {
        if (file != null) {
            try {
                Main.frame.setTitle("Checkstyle : " + file.getName());
                FileText text = new FileText(file.getAbsoluteFile(), ParseTreeInfoPanel.getEncoding());
                DetailAST parseTree = ParseTreeInfoPanel.parseFile(text);
                this.parseTreeModel.setParseTree(parseTree);
                this.currentFile = file;
                this.lastDirectory = file.getParentFile();
                this.reloadAction.setEnabled(true);
                String[] sourceLines = text.toLinesArray();
                this.getLines2position().clear();
                this.getLines2position().add(0);
                for (String element : sourceLines) {
                    this.getLines2position().add(this.jTextArea.getText().length());
                    this.jTextArea.append(element + "\n");
                }
                if (this.jTextArea.getText().length() != 0) {
                    this.jTextArea.replaceRange("", 0, this.jTextArea.getText().length());
                }
                for (String element : sourceLines) {
                    this.jTextArea.append(element + "\n");
                }
                this.jTextArea.moveCaretPosition(0);
            }
            catch (ANTLRException | IOException ex) {
                this.showErrorDialog(parent, "Could not parse" + file + ": " + ex.getMessage());
            }
        }
    }

    @Deprecated
    public static DetailAST parseFile(String fileName) throws IOException, ANTLRException {
        return ParseTreeInfoPanel.parseFile(new FileText(new File(fileName), ParseTreeInfoPanel.getEncoding()));
    }

    public static DetailAST parseFile(FileText text) throws ANTLRException {
        FileContents contents = new FileContents(text);
        return TreeWalker.parse(contents);
    }

    private static String getEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    public ParseTreeInfoPanel() {
        this.setLayout(new BorderLayout());
        DetailAST treeRoot = null;
        this.parseTreeModel = new ParseTreeModel(treeRoot);
        this.treeTable = new JTreeTable(this.parseTreeModel);
        JScrollPane sp = new JScrollPane(this.treeTable);
        this.add((Component)sp, "North");
        JButton fileSelectionButton = new JButton(new FileSelectionAction());
        this.reloadAction = new ReloadAction();
        this.reloadAction.setEnabled(false);
        JButton reloadButton = new JButton(this.reloadAction);
        this.jTextArea = new JTextArea(20, 15);
        this.jTextArea.setEditable(false);
        this.treeTable.setEditor(this.jTextArea);
        this.treeTable.setLinePositionMap(this.lines2position);
        JScrollPane sp2 = new JScrollPane(this.jTextArea);
        this.add((Component)sp2, "Center");
        JPanel p = new JPanel(new GridLayout(1, 2));
        this.add((Component)p, "South");
        p.add(fileSelectionButton);
        p.add(reloadButton);
        try {
            new FileDrop(sp, new FileDropListener(sp));
        }
        catch (TooManyListenersException ex) {
            this.showErrorDialog(null, "Cannot initialize Drag and Drop support");
        }
    }

    private void showErrorDialog(final Component parent, final String msg) {
        Runnable showError = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, msg);
            }
        };
        SwingUtilities.invokeLater(showError);
    }

    public List<Integer> getLines2position() {
        return this.lines2position;
    }

    private class FileDropListener
    implements FileDrop.Listener {
        private final JScrollPane mSp;

        @Override
        public void filesDropped(File[] files) {
            if (files != null && files.length > 0) {
                File file = files[0];
                ParseTreeInfoPanel.this.openFile(file, this.mSp);
            }
        }

        public FileDropListener(JScrollPane aSp) {
            this.mSp = aSp;
        }
    }

    private class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -1021880396046355863L;

        public ReloadAction() {
            super("Reload Java File");
            this.putValue("MnemonicKey", 82);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component parent = SwingUtilities.getRoot(ParseTreeInfoPanel.this);
            ParseTreeInfoPanel.this.openFile(ParseTreeInfoPanel.this.currentFile, parent);
        }
    }

    private class FileSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -1926935338069418119L;

        public FileSelectionAction() {
            super("Select Java File");
            this.putValue("MnemonicKey", 83);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(ParseTreeInfoPanel.this.lastDirectory);
            JavaFileFilter filter = new JavaFileFilter();
            fc.setFileFilter(filter);
            Component parent = SwingUtilities.getRoot(ParseTreeInfoPanel.this);
            fc.showDialog(parent, "Open");
            File file = fc.getSelectedFile();
            ParseTreeInfoPanel.this.openFile(file, parent);
        }
    }

    private static class JavaFileFilter
    extends FileFilter {
        private JavaFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            return f.isDirectory() || f.getName().endsWith(".java");
        }

        @Override
        public String getDescription() {
            return "Java Source Code";
        }
    }
}

