/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableCleaner
extends SimplifiedVisitor
implements AttributeVisitor {
    private boolean deleteLocalVariableTableAttribute;
    private boolean deleteLocalVariableTypeTableAttribute;

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        AttributesEditor attributesEditor;
        this.deleteLocalVariableTableAttribute = false;
        this.deleteLocalVariableTypeTableAttribute = false;
        codeAttribute.attributesAccept(clazz, method, this);
        if (this.deleteLocalVariableTableAttribute) {
            attributesEditor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)((Object)method), codeAttribute, true);
            attributesEditor.deleteAttribute("LocalVariableTable");
        }
        if (this.deleteLocalVariableTypeTableAttribute) {
            attributesEditor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)((Object)method), codeAttribute, true);
            attributesEditor.deleteAttribute("LocalVariableTypeTable");
        }
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.removeUnusedLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
        this.trimLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
        if (localVariableTableAttribute.u2localVariableTableLength == 0) {
            this.deleteLocalVariableTableAttribute = true;
        }
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeUnusedLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
        this.trimLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
        if (localVariableTypeTableAttribute.u2localVariableTypeTableLength == 0) {
            this.deleteLocalVariableTypeTableAttribute = true;
        }
    }

    private int removeUnusedLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[i];
            if (localVariableInfo.u2index < 0 || localVariableInfo.u2index >= n2 || localVariableInfo.u2length <= 0) continue;
            localVariableInfoArray[n3++] = localVariableInfoArray[i];
        }
        Arrays.fill(localVariableInfoArray, n3, n, null);
        return n3;
    }

    private int removeUnusedLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[i];
            if (localVariableTypeInfo.u2index < 0 || localVariableTypeInfo.u2index >= n2 || localVariableTypeInfo.u2length <= 0) continue;
            localVariableTypeInfoArray[n3++] = localVariableTypeInfoArray[i];
        }
        Arrays.fill(localVariableTypeInfoArray, n3, n, null);
        return n3;
    }

    private void trimLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        Arrays.sort(localVariableInfoArray, 0, n);
        int[] nArray = this.createMaxArray(n2);
        for (int i = n - 1; i >= 0; --i) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[i];
            int n3 = nArray[localVariableInfo.u2index] - localVariableInfo.u2startPC;
            if (localVariableInfo.u2length > n3) {
                localVariableInfo.u2length = n3;
            }
            nArray[localVariableInfo.u2index] = localVariableInfo.u2startPC;
        }
    }

    private void trimLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n, int n2) {
        Arrays.sort(localVariableTypeInfoArray, 0, n);
        int[] nArray = this.createMaxArray(n2);
        for (int i = n - 1; i >= 0; --i) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[i];
            int n3 = nArray[localVariableTypeInfo.u2index] - localVariableTypeInfo.u2startPC;
            if (localVariableTypeInfo.u2length > n3) {
                localVariableTypeInfo.u2length = n3;
            }
            nArray[localVariableTypeInfo.u2index] = localVariableTypeInfo.u2startPC;
        }
    }

    private int[] createMaxArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Integer.MAX_VALUE;
        }
        return nArray;
    }
}

