Polymer({

    is: 'iron-pages',

    behaviors: [
      Polymer.IronResizableBehavior,
      Polymer.IronSelectableBehavior
    ],

    properties: {

      // as the selected page is the only one visible, activateEvent
      // is both non-sensical and problematic; e.g. in cases where a user
      // handler attempts to change the page and the activateEvent
      // handler immediately changes it back
      activateEvent: {
        type: String,
        value: null
      }

    },

    observers: [
      '_selectedPageChanged(selected)'
    ],

    _selectedPageChanged: function(selected, old) {
      this.async(this.notifyResize);
    }
  });