#
# Copyright (C) 2013 Google Inc. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#         * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#         * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#         * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

{
    'variables': {
        # If debug_devtools is set to 1, JavaScript files for DevTools are
        # stored as is. Otherwise, a concatenated file is stored.
        'debug_devtools%': 0,
        # This list should contain all "autostart" modules from all apps.
        'devtools_core_files': [
            '<@(devtools_bindings_js_files)',
            '<@(devtools_common_js_files)',
            '<@(devtools_components_js_files)',
            '<@(devtools_core_base_files)',
            '<@(devtools_emulation_js_files)',
            '<@(devtools_host_js_files)',
            '<@(devtools_main_js_files)',
            '<@(devtools_platform_js_files)',
            '<@(devtools_sass_js_files)',
            '<@(devtools_sdk_js_files)',
            '<@(devtools_toolbox_bootstrap_js_files)',
            '<@(devtools_ui_js_files)',
            '<@(devtools_workspace_js_files)',
            '<@(devtools_core_css_files)',
        ],
        'devtools_compatibility_scripts': [
            'front_end/devtools.js',
        ],
        'devtools_core_base_files': [
            'front_end/inspector.css',
            'front_end/inspector.js',
            'front_end/inspector.json',
            'front_end/toolbox.css',
            'front_end/toolbox.js',
            'front_end/toolbox.json',
            'front_end/Runtime.js',
        ],
        'devtools_core_css_files': [
            'front_end/inspectorStyle.css',
            'front_end/popover.css',
            'front_end/sidebarPane.css',
        ],
        'devtools_common_js_files': [
            'front_end/common/Color.js',
            'front_end/common/Console.js',
            'front_end/common/ContentProvider.js',
            'front_end/common/Geometry.js',
            'front_end/common/ModuleExtensionInterfaces.js',
            'front_end/common/NotificationService.js',
            'front_end/common/Object.js',
            'front_end/common/ParsedURL.js',
            'front_end/common/Progress.js',
            'front_end/common/ResourceType.js',
            'front_end/common/Settings.js',
            'front_end/common/StaticContentProvider.js',
            'front_end/common/OutputStream.js',
            'front_end/common/TestBase.js',
            'front_end/common/TextDictionary.js',
            'front_end/common/TextRange.js',
            'front_end/common/TextUtils.js',
            'front_end/common/Throttler.js',
            'front_end/common/UIString.js',
            'front_end/common/WebInspector.js',
            'front_end/common/WorkerRuntime.js',
        ],
        'devtools_components_js_files': [
            'front_end/components/breakpointsList.css',
            'front_end/components/customPreviewSection.css',
            'front_end/components/domUtils.css',
            'front_end/components/inspectorViewTabbedPane.css',
            'front_end/components/objectPropertiesSection.css',
            'front_end/components/objectValue.css',
            'front_end/components/CustomPreviewSection.js',
            'front_end/components/DataSaverInfobar.js',
            'front_end/components/DebuggerPresentationUtils.js',
            'front_end/components/DockController.js',
            'front_end/components/DOMBreakpointsSidebarPane.js',
            'front_end/components/DOMPresentationUtils.js',
            'front_end/components/Drawer.js',
            'front_end/components/ExecutionContextSelector.js',
            'front_end/components/ExecutionContextModel.js',
            'front_end/components/HandlerRegistry.js',
            'front_end/components/InspectorView.js',
            'front_end/components/BreakpointsSidebarPaneBase.js',
            'front_end/components/Linkifier.js',
            'front_end/components/ObjectPopoverHelper.js',
            'front_end/components/ObjectPropertiesSection.js',
            'front_end/components/RemoteObjectPreviewFormatter.js',
            'front_end/components/ShortcutsScreen.js',
            'front_end/components/EventListenersUtils.js',
            'front_end/components/EventListenersView.js',
            'front_end/components/Reload.js',
        ],
        'devtools_host_js_files': [
            'front_end/host/InspectorFrontendHostAPI.js',
            'front_end/host/InspectorFrontendHost.js',
            'front_end/host/Platform.js',
            'front_end/host/ResourceLoader.js',
            'front_end/host/UserMetrics.js',
        ],
        'devtools_sass_js_files': [
            'front_end/sass/SASSLiveSourceMap.js',
            'front_end/sass/SASSSupport.js',
        ],
        'devtools_screencast_js_files': [
            'front_end/screencast/screencastView.css',
            'front_end/screencast/ScreencastApp.js',
            'front_end/screencast/ScreencastView.js',
        ],
        'devtools_sdk_js_files': [
            'front_end/sdk/ApplicationCacheModel.js',
            'front_end/sdk/ConsoleModel.js',
            'front_end/sdk/ContentProviders.js',
            'front_end/sdk/CookieParser.js',
            'front_end/sdk/CPUProfileDataModel.js',
            'front_end/sdk/CPUProfilerModel.js',
            'front_end/sdk/CSSMetadata.js',
            'front_end/sdk/CSSParser.js',
            'front_end/sdk/CSSStyleModel.js',
            'front_end/sdk/DebuggerModel.js',
            'front_end/sdk/DOMModel.js',
            'front_end/sdk/HAREntry.js',
            'front_end/sdk/HeapProfilerModel.js',
            'front_end/sdk/InspectorBackend.js',
            'front_end/sdk/InspectorBackendHostedMode.js',
            'front_end/sdk/NetworkLog.js',
            'front_end/sdk/NetworkManager.js',
            'front_end/sdk/NetworkRequest.js',
            'front_end/sdk/PaintProfiler.js',
            'front_end/sdk/RemoteObject.js',
            'front_end/sdk/Resource.js',
            'front_end/sdk/ResourceTreeModel.js',
            'front_end/sdk/RuntimeModel.js',
            'front_end/sdk/Script.js',
            'front_end/sdk/ServiceWorkerManager.js',
            'front_end/sdk/SourceMap.js',
            'front_end/sdk/Target.js',
            'front_end/sdk/TracingManager.js',
            'front_end/sdk/TracingModel.js',
            'front_end/sdk/WorkerManager.js',
        ],
        'devtools_workspace_js_files': [
            'front_end/workspace/FileManager.js',
            'front_end/workspace/FileSystemMapping.js',
            'front_end/workspace/IsolatedFileSystem.js',
            'front_end/workspace/IsolatedFileSystemManager.js',
            'front_end/workspace/SearchConfig.js',
            'front_end/workspace/UISourceCode.js',
            'front_end/workspace/Workspace.js',
        ],
        'devtools_bindings_js_files': [
            'front_end/bindings/BlackboxSupport.js',
            'front_end/bindings/BreakpointManager.js',
            'front_end/bindings/CompilerScriptMapping.js',
            'front_end/bindings/ContentProviderBasedProject.js',
            'front_end/bindings/CSSWorkspaceBinding.js',
            'front_end/bindings/DebuggerWorkspaceBinding.js',
            'front_end/bindings/DefaultScriptMapping.js',
            'front_end/bindings/FileSystemWorkspaceBinding.js',
            'front_end/bindings/FileUtils.js',
            'front_end/bindings/LiveLocation.js',
            'front_end/bindings/NetworkMapping.js',
            'front_end/bindings/NetworkProject.js',
            'front_end/bindings/PresentationConsoleMessageHelper.js',
            'front_end/bindings/ResourceScriptMapping.js',
            'front_end/bindings/ResourceUtils.js',
            'front_end/bindings/SASSSourceMapping.js',
            'front_end/bindings/StylesSourceMapping.js',
            'front_end/bindings/TempFile.js',
        ],
        'devtools_platform_js_files': [
            'front_end/platform/DOMExtension.js',
            'front_end/platform/utilities.js',
        ],
        'devtools_toolbox_bootstrap_js_files': [
            'front_end/toolbox_bootstrap/Toolbox.js',
        ],
        'devtools_emulation_js_files': [
            'front_end/emulation/devicesSettingsTab.css',
            'front_end/emulation/deviceModeToolbar.css',
            'front_end/emulation/deviceModeView.css',
            'front_end/emulation/mediaQueryInspector.css',
            'front_end/emulation/overrides.css',
            'front_end/emulation/sensors.css',
            'front_end/emulation/responsiveDesignView.css',
            'front_end/emulation/DeviceModeButton.js',
            'front_end/emulation/DeviceModeModel.js',
            'front_end/emulation/DeviceModeView.js',
            'front_end/emulation/DevicesSettingsTab.js',
            'front_end/emulation/EmulatedDevices.js',
            'front_end/emulation/InspectedPagePlaceholder.js',
            'front_end/emulation/MediaQueryInspector.js',
            'front_end/emulation/OverridesSupport.js',
            'front_end/emulation/OverridesView.js',
            'front_end/emulation/OverridesUI.js',
            'front_end/emulation/ResponsiveDesignView.js',
            'front_end/emulation/SensorsView.js',
        ],
        'devtools_ui_js_files': [
            'front_end/ui/checkboxTextLabel.css',
            'front_end/ui/closeButton.css',
            'front_end/ui/colorSwatch.css',
            'front_end/ui/dialog.css',
            'front_end/ui/dropTarget.css',
            'front_end/ui/emptyWidget.css',
            'front_end/ui/filter.css',
            'front_end/ui/infobar.css',
            'front_end/ui/inspectorCommon.css',
            'front_end/ui/inspectorSyntaxHighlight.css',
            'front_end/ui/inspectorSyntaxHighlightDark.css',
            'front_end/ui/listWidget.css',
            'front_end/ui/panelEnablerView.css',
            'front_end/ui/progressIndicator.css',
            'front_end/ui/propertiesSection.css',
            'front_end/ui/radioButton.css',
            'front_end/ui/searchableView.css',
            'front_end/ui/section.css',
            'front_end/ui/softContextMenu.css',
            'front_end/ui/smallIcon.css',
            'front_end/ui/splitWidget.css',
            'front_end/ui/toolbar.css',
            'front_end/ui/tooltip.css',
            'front_end/ui/suggestBox.css',
            'front_end/ui/tabbedPane.css',
            'front_end/ui/textButton.css',
            'front_end/ui/textPrompt.css',
            'front_end/ui/treeoutline.css',
            'front_end/ui/ActionRegistry.js',
            'front_end/ui/ColorSwatch.js',
            'front_end/ui/Context.js',
            'front_end/ui/ContextMenu.js',
            'front_end/ui/Dialog.js',
            'front_end/ui/DOMSyntaxHighlighter.js',
            'front_end/ui/DropDownMenu.js',
            'front_end/ui/DropTarget.js',
            'front_end/ui/EmptyWidget.js',
            'front_end/ui/FilterBar.js',
            'front_end/ui/ForwardedInputEventHandler.js',
            'front_end/ui/HistoryInput.js',
            'front_end/ui/Infobar.js',
            'front_end/ui/InplaceEditor.js',
            'front_end/ui/KeyboardShortcut.js',
            'front_end/ui/ListWidget.js',
            'front_end/ui/Panel.js',
            'front_end/ui/Popover.js',
            'front_end/ui/ProgressIndicator.js',
            'front_end/ui/ResizerWidget.js',
            'front_end/ui/RootView.js',
            'front_end/ui/SearchableView.js',
            'front_end/ui/Section.js',
            'front_end/ui/SettingsUI.js',
            'front_end/ui/ShortcutRegistry.js',
            'front_end/ui/SidebarPane.js',
            'front_end/ui/SidebarTreeElement.js',
            'front_end/ui/SoftContextMenu.js',
            'front_end/ui/SplitWidget.js',
            'front_end/ui/StackView.js',
            'front_end/ui/Toolbar.js',
            'front_end/ui/Tooltip.js',
            'front_end/ui/SuggestBox.js',
            'front_end/ui/TabbedPane.js',
            'front_end/ui/TextPrompt.js',
            'front_end/ui/UIUtils.js',
            'front_end/ui/ViewportControl.js',
            'front_end/ui/Widget.js',
            'front_end/ui/ZoomManager.js',
            'front_end/ui/treeoutline.js',
            'front_end/ui/ThrottledWidget.js'
        ],
        'devtools_main_js_files': [
            'front_end/main/errorWarningCounter.css',
            'front_end/main/remoteDebuggingTerminatedScreen.css',
            'front_end/main/renderingOptions.css',
            'front_end/main/targetCrashedScreen.css',
            'front_end/main/AdvancedApp.js',
            'front_end/main/Connections.js',
            'front_end/main/FrontendWebSocketAPI.js',
            'front_end/main/Main.js',
            'front_end/main/OverlayController.js',
            'front_end/main/RenderingOptions.js',
            'front_end/main/SimpleApp.js',
            'front_end/main/Tests.js',
        ],
        'devtools_module_json_files': [
            'front_end/accessibility/module.json',
            'front_end/animation/module.json',
            'front_end/audits/module.json',
            'front_end/bindings/module.json',
            'front_end/cm_modes/module.json',
            'front_end/common/module.json',
            'front_end/components/module.json',
            'front_end/components_lazy/module.json',
            'front_end/console/module.json',
            'front_end/devices/module.json',
            'front_end/diff/module.json',
            'front_end/elements/module.json',
            'front_end/emulated_devices/module.json',
            'front_end/emulation/module.json',
            'front_end/extensions/module.json',
            'front_end/heap_snapshot_worker/module.json',
            'front_end/host/module.json',
            'front_end/layers/module.json',
            'front_end/main/module.json',
            'front_end/network/module.json',
            'front_end/platform/module.json',
            'front_end/profiler/module.json',
            'front_end/promises/module.json',
            'front_end/resources/module.json',
            'front_end/sass/module.json',
            'front_end/security/module.json',
            'front_end/screencast/module.json',
            'front_end/script_formatter_worker/module.json',
            'front_end/sdk/module.json',
            'front_end/settings/module.json',
            'front_end/source_frame/module.json',
            'front_end/sources/module.json',
            'front_end/snippets/module.json',
            'front_end/temp_storage_shared_worker/module.json',
            'front_end/timeline/module.json',
            'front_end/toolbox_bootstrap/module.json',
            'front_end/ui/module.json',
            'front_end/ui_lazy/module.json',
            'front_end/workspace/module.json',
        ],
        'all_devtools_files': [
            '<@(devtools_cm_css_files)',
            '<@(devtools_cm_js_files)',
            '<@(devtools_core_files)',
            '<@(devtools_module_json_files)',
            '<@(devtools_modules_js_files)',
            '<@(devtools_acorn_files)',
        ],

        # Lazy-loaded modules.
        'devtools_accessibility_js_files': [
            'front_end/accessibility/accessibilityNode.css',
            'front_end/accessibility/AccessibilityModel.js',
            'front_end/accessibility/AccessibilitySidebarView.js',
            'front_end/accessibility/AccessibilityStrings.js',
        ],
        'devtools_animation_js_files': [
            'front_end/animation/animationScreenshotPopover.css',
            'front_end/animation/animationTimeline.css',
            'front_end/animation/AnimationGroupPreviewUI.js',
            'front_end/animation/AnimationModel.js',
            'front_end/animation/AnimationScreenshotPopover.js',
            'front_end/animation/AnimationTimeline.js',
            'front_end/animation/AnimationUI.js',
        ],
        'devtools_audits_js_files': [
            'front_end/audits/auditResultTree.css',
            'front_end/audits/auditsPanel.css',
            'front_end/audits/AuditCategories.js',
            'front_end/audits/AuditCategory.js',
            'front_end/audits/AuditController.js',
            'front_end/audits/AuditExtensionCategory.js',
            'front_end/audits/AuditFormatters.js',
            'front_end/audits/AuditLauncherView.js',
            'front_end/audits/AuditResultView.js',
            'front_end/audits/AuditRules.js',
            'front_end/audits/AuditsPanel.js',
        ],
        'devtools_cm_modes_js_files': [
            'front_end/cm_modes/clike.js',
            'front_end/cm_modes/coffeescript.js',
            'front_end/cm_modes/php.js',
            'front_end/cm_modes/python.js',
            'front_end/cm_modes/shell.js',
            'front_end/cm_modes/livescript.js',
            'front_end/cm_modes/clojure.js',
            'front_end/cm_modes/DefaultCodeMirrorMimeMode.js',
        ],
        'devtools_components_lazy_js_files': [
            'front_end/components_lazy/filmStripDialog.css',
            'front_end/components_lazy/filmStripView.css',
            'front_end/components_lazy/CookiesTable.js',
            'front_end/components_lazy/FilmStripModel.js',
            'front_end/components_lazy/FilmStripView.js',
        ],
        'devtools_console_js_files': [
            'front_end/console/consoleView.css',
            'front_end/console/ConsolePanel.js',
            'front_end/console/ConsoleView.js',
            'front_end/console/ConsoleViewMessage.js',
        ],
        'devtools_devices_js_files': [
            'front_end/devices/devicesView.css',
            'front_end/devices/DevicesDialog.js',
            'front_end/devices/DevicesView.js',
        ],
        'devtools_diff_js_files': [
            'front_end/diff/Diff.js',
            'front_end/diff/diff_match_patch.js',
        ],
        'devtools_elements_js_files': [
            'front_end/elements/bezierEditor.css',
            'front_end/elements/breadcrumbs.css',
            'front_end/elements/computedStyleSidebarPane.css',
            'front_end/elements/elementsPanel.css',
            'front_end/elements/elementsTreeOutline.css',
            'front_end/elements/spectrum.css',
            'front_end/elements/BezierEditor.js',
            'front_end/elements/BezierUI.js',
            'front_end/elements/ClassesPaneWidget.js',
            'front_end/elements/ElementsBreadcrumbs.js',
            'front_end/elements/ElementsPanel.js',
            'front_end/elements/ElementsSidebarPane.js',
            'front_end/elements/ElementsSidebarView.js',
            'front_end/elements/ElementsTreeElement.js',
            'front_end/elements/ElementsTreeElementHighlighter.js',
            'front_end/elements/ElementsTreeOutline.js',
            'front_end/elements/ElementStatePaneWidget.js',
            'front_end/elements/SharedSidebarModel.js',
            'front_end/elements/EventListenersWidget.js',
            'front_end/elements/InspectElementModeController.js',
            'front_end/elements/MetricsSidebarPane.js',
            'front_end/elements/PlatformFontsWidget.js',
            'front_end/elements/PropertiesWidget.js',
            'front_end/elements/PropertyChangeHighlighter.js',
            'front_end/elements/Spectrum.js',
            'front_end/elements/StylesPopoverHelper.js',
            'front_end/elements/StylesSidebarPane.js',
            'front_end/elements/ComputedStyleWidget.js',
        ],
        'devtools_emulated_devices_js_files': [
        ],
        'devtools_emulated_devices_images': [
            'front_end/emulated_devices/google-nexus-5-horizontal-default-1x.png',
            'front_end/emulated_devices/google-nexus-5-horizontal-default-2x.png',
            'front_end/emulated_devices/google-nexus-5-horizontal-keyboard-1x.png',
            'front_end/emulated_devices/google-nexus-5-horizontal-keyboard-2x.png',
            'front_end/emulated_devices/google-nexus-5-horizontal-navigation-1x.png',
            'front_end/emulated_devices/google-nexus-5-horizontal-navigation-2x.png',
            'front_end/emulated_devices/google-nexus-5-vertical-default-1x.png',
            'front_end/emulated_devices/google-nexus-5-vertical-default-2x.png',
            'front_end/emulated_devices/google-nexus-5-vertical-keyboard-1x.png',
            'front_end/emulated_devices/google-nexus-5-vertical-keyboard-2x.png',
            'front_end/emulated_devices/google-nexus-5-vertical-navigation-1x.png',
            'front_end/emulated_devices/google-nexus-5-vertical-navigation-2x.png',
            'front_end/emulated_devices/google-nexus-5x-horizontal-default-1x.png',
            'front_end/emulated_devices/google-nexus-5x-horizontal-default-2x.png',
            'front_end/emulated_devices/google-nexus-5x-horizontal-keyboard-1x.png',
            'front_end/emulated_devices/google-nexus-5x-horizontal-keyboard-2x.png',
            'front_end/emulated_devices/google-nexus-5x-horizontal-navigation-1x.png',
            'front_end/emulated_devices/google-nexus-5x-horizontal-navigation-2x.png',
            'front_end/emulated_devices/google-nexus-5x-vertical-default-1x.png',
            'front_end/emulated_devices/google-nexus-5x-vertical-default-2x.png',
            'front_end/emulated_devices/google-nexus-5x-vertical-keyboard-1x.png',
            'front_end/emulated_devices/google-nexus-5x-vertical-keyboard-2x.png',
            'front_end/emulated_devices/google-nexus-5x-vertical-navigation-1x.png',
            'front_end/emulated_devices/google-nexus-5x-vertical-navigation-2x.png',
        ],
        'devtools_extensions_js_files': [
            'front_end/extensions/ExtensionAuditCategory.js',
            'front_end/extensions/ExtensionPanel.js',
            'front_end/extensions/ExtensionRegistryStub.js',
            'front_end/extensions/ExtensionServer.js',
            'front_end/extensions/ExtensionView.js',
            '<@(devtools_extension_api_files)',
        ],
        'devtools_promises_js_files': [
            'front_end/promises/promisePane.css',
            'front_end/promises/PromisePane.js',
        ],
        'devtools_heap_snapshot_worker_js_files': [
            'front_end/common/TextUtils.js',
            'front_end/common/UIString.js',
            'front_end/heap_snapshot_worker/AllocationProfile.js',
            'front_end/heap_snapshot_worker/HeapSnapshot.js',
            'front_end/heap_snapshot_worker/HeapSnapshotLoader.js',
            'front_end/heap_snapshot_worker/HeapSnapshotWorker.js',
            'front_end/heap_snapshot_worker/HeapSnapshotWorkerDispatcher.js',
            'front_end/heap_snapshot_worker/JSHeapSnapshot.js',
            'front_end/platform/utilities.js',
            'front_end/profiler/HeapSnapshotCommon.js',
        ],
        'devtools_layers_js_files': [
            'front_end/layers/LayerPaintProfilerView.js',
            'front_end/layers/LayersPanel.js',
        ],
        'devtools_network_js_files': [
            'front_end/network/blockedURLsPane.css',
            'front_end/network/eventSourceMessagesView.css',
            'front_end/network/networkConditionsSettingsTab.css',
            'front_end/network/networkConfigView.css',
            'front_end/network/networkLogView.css',
            'front_end/network/networkPanel.css',
            'front_end/network/requestCookiesView.css',
            'front_end/network/requestHeadersView.css',
            'front_end/network/webSocketFrameView.css',
            'front_end/network/xmlView.css',
            'front_end/network/BlockedURLsPane.js',
            'front_end/network/EventSourceMessagesView.js',
            'front_end/network/FilterSuggestionBuilder.js',
            'front_end/network/HARWriter.js',
            'front_end/network/JSONView.js',
            'front_end/network/NetworkConditionsSelector.js',
            'front_end/network/NetworkConfigView.js',
            'front_end/network/NetworkDataGridNode.js',
            'front_end/network/NetworkItemView.js',
            'front_end/network/NetworkLogView.js',
            'front_end/network/NetworkOverview.js',
            'front_end/network/NetworkPanel.js',
            'front_end/network/NetworkTimeCalculator.js',
            'front_end/network/RequestCookiesView.js',
            'front_end/network/RequestHeadersView.js',
            'front_end/network/RequestHTMLView.js',
            'front_end/network/RequestPreviewView.js',
            'front_end/network/RequestResponseView.js',
            'front_end/network/RequestTimingView.js',
            'front_end/network/RequestView.js',
            'front_end/network/ResourceWebSocketFrameView.js',
            'front_end/network/XMLView.js',
        ],
        'devtools_profiler_js_files': [
            'front_end/profiler/heapProfiler.css',
            'front_end/profiler/profilesPanel.css',
            'front_end/profiler/CPUProfileBottomUpDataGrid.js',
            'front_end/profiler/CPUProfileDataGrid.js',
            'front_end/profiler/CPUProfileFlameChart.js',
            'front_end/profiler/CPUProfileTopDownDataGrid.js',
            'front_end/profiler/CPUProfileView.js',
            'front_end/profiler/HeapSnapshotCommon.js',
            'front_end/profiler/HeapSnapshotDataGrids.js',
            'front_end/profiler/HeapSnapshotGridNodes.js',
            'front_end/profiler/HeapSnapshotProxy.js',
            'front_end/profiler/HeapSnapshotView.js',
            'front_end/profiler/ProfileLauncherView.js',
            'front_end/profiler/ProfilesPanel.js',
            'front_end/profiler/ProfileTypeRegistry.js',
            'front_end/profiler/TargetsComboBoxController.js',
        ],
        'devtools_resources_js_files': [
            'front_end/resources/indexedDBViews.css',
            'front_end/resources/resourcesPanel.css',
            'front_end/resources/serviceWorkerCacheViews.css',
            'front_end/resources/serviceWorkersView.css',
            'front_end/resources/ApplicationCacheItemsView.js',
            'front_end/resources/CookieItemsView.js',
            'front_end/resources/DatabaseModel.js',
            'front_end/resources/DatabaseQueryView.js',
            'front_end/resources/DatabaseTableView.js',
            'front_end/resources/DirectoryContentView.js',
            'front_end/resources/DOMStorageModel.js',
            'front_end/resources/DOMStorageItemsView.js',
            'front_end/resources/FileContentView.js',
            'front_end/resources/FileSystemModel.js',
            'front_end/resources/FileSystemView.js',
            'front_end/resources/IndexedDBViews.js',
            'front_end/resources/IndexedDBModel.js',
            'front_end/resources/ResourcesPanel.js',
            'front_end/resources/ServiceWorkerCacheViews.js',
            'front_end/resources/ServiceWorkersView.js',
        ],
        'devtools_security_js_files': [
            'front_end/security/lockIcon.css',
            'front_end/security/mainView.css',
            'front_end/security/originView.css',
            'front_end/security/sidebar.css',
            'front_end/security/SecurityModel.js',
            'front_end/security/SecurityPanel.js',
        ],
        'devtools_script_formatter_worker_js_files': [
            'front_end/acorn/acorn.js',
            'front_end/cm/css.js',
            'front_end/cm/headlesscodemirror.js',
            'front_end/cm/htmlmixed.js',
            'front_end/cm/xml.js',
            'front_end/platform/utilities.js',
            'front_end/script_formatter_worker/AcornTokenizer.js',
            'front_end/script_formatter_worker/CSSFormatter.js',
            'front_end/script_formatter_worker/ESTreeWalker.js',
            'front_end/script_formatter_worker/JavaScriptFormatter.js',
            'front_end/script_formatter_worker/ScriptFormatterWorker.js',
        ],
        'devtools_settings_js_files': [
            'front_end/settings/editFileSystemView.css',
            'front_end/settings/frameworkBlackboxSettingsTab.css',
            'front_end/settings/settingsScreen.css',
            'front_end/settings/EditFileSystemView.js',
            'front_end/settings/FrameworkBlackboxSettingsTab.js',
            'front_end/settings/SettingsScreen.js',
        ],
        'devtools_source_frame_js_files': [
            'front_end/source_frame/cmdevtools.css',
            'front_end/source_frame/fontView.css',
            'front_end/source_frame/imageView.css',
            'front_end/source_frame/CodeMirrorDictionary.js',
            'front_end/source_frame/CodeMirrorTextEditor.js',
            'front_end/source_frame/CodeMirrorUtils.js',
            'front_end/source_frame/FontView.js',
            'front_end/source_frame/ImageView.js',
            'front_end/source_frame/ResourceSourceFrame.js',
            'front_end/source_frame/SourceFrame.js',
            'front_end/source_frame/TextEditorAutocompleteController.js',
        ],
        'devtools_sources_js_files': [
            'front_end/sources/addSourceMapURLDialog.css',
            'front_end/sources/navigatorView.css',
            'front_end/sources/revisionHistory.css',
            'front_end/sources/serviceWorkersSidebar.css',
            'front_end/sources/sourcesPanel.css',
            'front_end/sources/sourcesSearch.css',
            'front_end/sources/sourcesView.css',
            'front_end/sources/uiList.css',
            'front_end/sources/AddSourceMapURLDialog.js',
            'front_end/sources/AdvancedSearchView.js',
            'front_end/sources/AsyncOperationsSidebarPane.js',
            'front_end/sources/CallStackSidebarPane.js',
            'front_end/sources/CSSSourceFrame.js',
            'front_end/sources/EditingLocationHistoryManager.js',
            'front_end/sources/EventListenerBreakpointsSidebarPane.js',
            'front_end/sources/FileBasedSearchResultsPane.js',
            'front_end/sources/FilePathScoreFunction.js',
            'front_end/sources/FilteredUISourceCodeListDelegate.js',
            'front_end/sources/InplaceFormatterEditorAction.js',
            'front_end/sources/JavaScriptBreakpointsSidebarPane.js',
            'front_end/sources/JavaScriptCompiler.js',
            'front_end/sources/JavaScriptOutlineDialog.js',
            'front_end/sources/JavaScriptSourceFrame.js',
            'front_end/sources/NavigatorView.js',
            'front_end/sources/ObjectEventListenersSidebarPane.js',
            'front_end/sources/OpenResourceDialog.js',
            'front_end/sources/RevisionHistoryView.js',
            'front_end/sources/ScopeChainSidebarPane.js',
            'front_end/sources/ScriptFormatter.js',
            'front_end/sources/ScriptFormatterEditorAction.js',
            'front_end/sources/ServiceWorkersSidebarPane.js',
            'front_end/sources/SimpleHistoryManager.js',
            'front_end/sources/SourcesNavigator.js',
            'front_end/sources/SourcesPanel.js',
            'front_end/sources/SourcesSearchScope.js',
            'front_end/sources/SourcesView.js',
            'front_end/sources/StyleSheetOutlineDialog.js',
            'front_end/sources/TabbedEditorContainer.js',
            'front_end/sources/ThreadsSidebarPane.js',
            'front_end/sources/UIList.js',
            'front_end/sources/UISourceCodeFrame.js',
            'front_end/sources/WatchExpressionsSidebarPane.js',
            'front_end/sources/WorkspaceMappingTip.js',
            'front_end/sources/XHRBreakpointsSidebarPane.js',
        ],
        'devtools_snippets_js_files': [
            'front_end/snippets/ScriptSnippetModel.js',
            'front_end/snippets/SnippetStorage.js',
        ],
        'devtools_temp_storage_shared_worker_js_files': [
            'front_end/temp_storage_shared_worker/TempStorageSharedWorker.js',
        ],
        'devtools_timeline_js_files': [
            'front_end/timeline/invalidationsTree.css',
            'front_end/timeline/timelineFlamechartPopover.css',
            'front_end/timeline/timelinePanel.css',
            'front_end/timeline/timelineStatusDialog.css',
            'front_end/timeline/CountersGraph.js',
            'front_end/timeline/LayerDetailsView.js',
            'front_end/timeline/LayerTreeModel.js',
            'front_end/timeline/LayerTreeOutline.js',
            'front_end/timeline/LayerViewHost.js',
            'front_end/timeline/Layers3DView.js',
            'front_end/timeline/MemoryCountersGraph.js',
            'front_end/timeline/PaintProfilerView.js',
            'front_end/timeline/TimelineEventOverview.js',
            'front_end/timeline/TimelineFlameChart.js',
            'front_end/timeline/TimelineFrameModel.js',
            'front_end/timeline/TimelineJSProfile.js',
            'front_end/timeline/TimelineLayersView.js',
            'front_end/timeline/TimelineModel.js',
            'front_end/timeline/TimelinePaintProfilerView.js',
            'front_end/timeline/TimelinePanel.js',
            'front_end/timeline/TimelineTreeView.js',
            'front_end/timeline/TimelineUIUtils.js',
            'front_end/timeline/TransformController.js',
        ],
        'devtools_ui_lazy_js_files': [
            'front_end/ui_lazy/dataGrid.css',
            'front_end/ui_lazy/filteredListWidget.css',
            'front_end/ui_lazy/flameChart.css',
            'front_end/ui_lazy/overviewGrid.css',
            'front_end/ui_lazy/pieChart.css',
            'front_end/ui_lazy/timelineGrid.css',
            'front_end/ui_lazy/DataGrid.js',
            'front_end/ui_lazy/FilteredListWidget.js',
            'front_end/ui_lazy/FlameChart.js',
            'front_end/ui_lazy/OverviewGrid.js',
            'front_end/ui_lazy/PieChart.js',
            'front_end/ui_lazy/ShowMoreDataGridNode.js',
            'front_end/ui_lazy/SortableDataGrid.js',
            'front_end/ui_lazy/TimelineGrid.js',
            'front_end/ui_lazy/TimelineOverviewPane.js',
            'front_end/ui_lazy/ViewportDataGrid.js',
        ],

        # Third-party code.
        'devtools_cm_css_files': [
            'front_end/cm/codemirror.css',
        ],
        'devtools_cm_js_files': [
            'front_end/cm/activeline.js',
            'front_end/cm/closebrackets.js',
            'front_end/cm/codemirror.js',
            'front_end/cm/comment.js',
            'front_end/cm/css.js',
            'front_end/cm/headlesscodemirror.js',
            'front_end/cm/htmlembedded.js',
            'front_end/cm/htmlmixed.js',
            'front_end/cm/javascript.js',
            'front_end/cm/markselection.js',
            'front_end/cm/matchbrackets.js',
            'front_end/cm/overlay.js',
            'front_end/cm/simple.js',
            'front_end/cm/xml.js',
        ],
        'devtools_acorn_files': [
            'front_end/acorn/acorn.js',
        ],

        'devtools_modules_js_files': [
            '<@(devtools_accessibility_js_files)',
            '<@(devtools_animation_js_files)',
            '<@(devtools_audits_js_files)',
            '<@(devtools_cm_modes_js_files)',
            '<@(devtools_components_lazy_js_files)',
            '<@(devtools_console_js_files)',
            '<@(devtools_devices_js_files)',
            '<@(devtools_diff_js_files)',
            '<@(devtools_elements_js_files)',
            '<@(devtools_emulated_devices_js_files)',
            '<@(devtools_extensions_js_files)',
            '<@(devtools_heap_snapshot_worker_js_files)',
            '<@(devtools_layers_js_files)',
            '<@(devtools_network_js_files)',
            '<@(devtools_profiler_js_files)',
            '<@(devtools_promises_js_files)',
            '<@(devtools_resources_js_files)',
            '<@(devtools_security_js_files)',
            '<@(devtools_screencast_js_files)',
            '<@(devtools_script_formatter_worker_js_files)',
            '<@(devtools_settings_js_files)',
            '<@(devtools_source_frame_js_files)',
            '<@(devtools_sources_js_files)',
            '<@(devtools_snippets_js_files)',
            '<@(devtools_temp_storage_shared_worker_js_files)',
            '<@(devtools_timeline_js_files)',
            '<@(devtools_ui_lazy_js_files)',
        ],
        'devtools_image_files': [
            'front_end/Images/applicationCache.png',
            'front_end/Images/breakpoint.png',
            'front_end/Images/breakpoint_2x.png',
            'front_end/Images/breakpointConditional.png',
            'front_end/Images/breakpointConditional_2x.png',
            'front_end/Images/checker.png',
            'front_end/Images/cookie.png',
            'front_end/Images/chromeDisabledSelect.png',
            'front_end/Images/chromeDisabledSelect_2x.png',
            'front_end/Images/chromeLeft.png',
            'front_end/Images/chromeMiddle.png',
            'front_end/Images/chromeRight.png',
            'front_end/Images/chromeSelect.png',
            'front_end/Images/chromeSelect_2x.png',
            'front_end/Images/database.png',
            'front_end/Images/databaseTable.png',
            'front_end/Images/deleteIcon.png',
            'front_end/Images/domain.png',
            'front_end/Images/errorWave.png',
            'front_end/Images/errorWave_2x.png',
            'front_end/Images/fileSystem.png',
            'front_end/Images/forward.png',
            'front_end/Images/frame.png',
            'front_end/Images/graphLabelCalloutLeft.png',
            'front_end/Images/graphLabelCalloutRight.png',
            'front_end/Images/ic_info_black_18dp.svg',
            'front_end/Images/ic_warning_black_18dp.svg',
            'front_end/Images/indexedDB.png',
            'front_end/Images/indexedDBIndex.png',
            'front_end/Images/indexedDBObjectStore.png',
            'front_end/Images/localStorage.png',
            'front_end/Images/navigationControls.png',
            'front_end/Images/navigationControls_2x.png',
            'front_end/Images/notifications.svg',
            'front_end/Images/paneAddButtons.png',
            'front_end/Images/paneFilterButtons.png',
            'front_end/Images/paneRefreshButtons.png',
            'front_end/Images/popoverArrows.png',
            'front_end/Images/profileGroupIcon.png',
            'front_end/Images/profileIcon.png',
            'front_end/Images/profileSmallIcon.png',
            'front_end/Images/radioDot.png',
            'front_end/Images/resizeDiagonal.png',
            'front_end/Images/resizeDiagonal_2x.png',
            'front_end/Images/resizeHorizontal.png',
            'front_end/Images/resizeHorizontal_2x.png',
            'front_end/Images/resizeVertical.png',
            'front_end/Images/resizeVertical_2x.png',
            'front_end/Images/resourceCSSIcon.png',
            'front_end/Images/resourceDocumentIcon.png',
            'front_end/Images/resourceDocumentIconSmall.png',
            'front_end/Images/resourceJSIcon.png',
            'front_end/Images/resourcePlainIcon.png',
            'front_end/Images/resourcePlainIconSmall.png',
            'front_end/Images/resourcesTimeGraphIcon.png',
            'front_end/Images/responsiveDesign.png',
            'front_end/Images/responsiveDesign_2x.png',
            'front_end/Images/searchNext.png',
            'front_end/Images/searchPrev.png',
            'front_end/Images/securityPropertyInfo.svg',
            'front_end/Images/securityPropertyInsecure.svg',
            'front_end/Images/securityPropertySecure.svg',
            'front_end/Images/securityPropertyWarning.svg',
            'front_end/Images/securityPropertyUnknown.svg',
            'front_end/Images/securityStateInsecure.svg',
            'front_end/Images/securityStateNeutral.svg',
            'front_end/Images/securityStateSecure.svg',
            'front_end/Images/serviceWorker.svg',
            'front_end/Images/sessionStorage.png',
            'front_end/Images/settingsListRemove.png',
            'front_end/Images/settingsListRemove_2x.png',
            'front_end/Images/speech.png',
            'front_end/Images/toolbarButtonGlyphs.png',
            'front_end/Images/toolbarButtonGlyphs_2x.png',
            'front_end/Images/toolbarResizerHorizontal.png',
            'front_end/Images/toolbarResizerVertical.png',
            'front_end/Images/toolbarItemSelected.png',
            'front_end/Images/touchCursor.png',
            'front_end/Images/touchCursor_2x.png',
            'front_end/Images/updateServiceWorker.svg',
        ],
        'devtools_extension_api_files': [
            'front_end/extensions/ExtensionAPI.js',
        ],
    },
}
