/*
 * Copyright (C) 2012 Google, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GOOGLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef UseCounter_h
#define UseCounter_h

#include "core/CSSPropertyNames.h"
#include "core/CoreExport.h"
#include "core/css/parser/CSSParserMode.h"
#include "wtf/BitVector.h"
#include "wtf/Noncopyable.h"
#include "wtf/text/WTFString.h"
#include <v8.h>

namespace blink {

class CSSStyleSheet;
class Document;
class ExecutionContext;
class Frame;
class LocalFrame;
class StyleSheetContents;

// UseCounter is used for counting the number of times features of
// Blink are used on real web pages and help us know commonly
// features are used and thus when it's safe to remove or change them.
//
// The Chromium Content layer controls what is done with this data.
// For instance, in Google Chrome, these counts are submitted
// anonymously through the Histogram recording system in Chrome
// for users who opt-in to "Usage Statistics" submission
// during their install of Google Chrome:
// http://www.google.com/chrome/intl/en/privacy.html

class CORE_EXPORT UseCounter {
    DISALLOW_NEW();
    WTF_MAKE_NONCOPYABLE(UseCounter);
public:
    UseCounter();
    ~UseCounter();

    enum Feature {
        // Do not change assigned numbers of existing items: add new features
        // to the end of the list.
        PageDestruction = 0,
        PrefixedIndexedDB = 3,
        WorkerStart = 4,
        SharedWorkerStart = 5,
        UnprefixedIndexedDB = 9,
        OpenWebDatabase = 10,
        UnprefixedRequestAnimationFrame = 13,
        PrefixedRequestAnimationFrame = 14,
        ContentSecurityPolicy = 15,
        ContentSecurityPolicyReportOnly = 16,
        PrefixedTransitionEndEvent = 18,
        UnprefixedTransitionEndEvent = 19,
        PrefixedAndUnprefixedTransitionEndEvent = 20,
        AutoFocusAttribute = 21,
        DataListElement = 23,
        FormAttribute = 24,
        IncrementalAttribute = 25,
        InputTypeColor = 26,
        InputTypeDate = 27,
        InputTypeDateTimeFallback = 29,
        InputTypeDateTimeLocal = 30,
        InputTypeEmail = 31,
        InputTypeMonth = 32,
        InputTypeNumber = 33,
        InputTypeRange = 34,
        InputTypeSearch = 35,
        InputTypeTel = 36,
        InputTypeTime = 37,
        InputTypeURL = 38,
        InputTypeWeek = 39,
        InputTypeWeekFallback = 40,
        ListAttribute = 41,
        MaxAttribute = 42,
        MinAttribute = 43,
        PatternAttribute = 44,
        PlaceholderAttribute = 45,
        PrefixedDirectoryAttribute = 47,
        RequiredAttribute = 49,
        StepAttribute = 51,
        PageVisits = 52,
        HTMLMarqueeElement = 53,
        Reflection = 55,
        PrefixedStorageInfo = 57,
        XFrameOptions = 58,
        XFrameOptionsSameOrigin = 59,
        XFrameOptionsSameOriginWithBadAncestorChain = 60,
        DeprecatedFlexboxWebContent = 61,
        DeprecatedFlexboxChrome = 62,
        DeprecatedFlexboxChromeExtension = 63,
        UnprefixedPerformanceTimeline = 65,
        UnprefixedUserTiming = 67,
        WindowEvent = 69,
        ContentSecurityPolicyWithBaseElement = 70,
        DocumentClear = 74,
        XMLDocument = 77,
        XSLProcessingInstruction = 78,
        XSLTProcessor = 79,
        SVGSwitchElement = 80,
        DocumentAll = 83,
        FormElement = 84,
        DemotedFormElement = 85,
        SVGAnimationElement = 90,
        LineClamp = 96,
        SubFrameBeforeUnloadRegistered = 97,
        SubFrameBeforeUnloadFired = 98,
        ConsoleMarkTimeline = 102,
        DocumentCreateAttribute = 111,
        DocumentCreateAttributeNS = 112,
        DocumentCreateCDATASection = 113, // Removed from DOM4.
        DocumentXMLEncoding = 115, // Removed from DOM4.
        DocumentXMLStandalone = 116, // Removed from DOM4.
        DocumentXMLVersion = 117, // Removed from DOM4.
        NavigatorProductSub = 123,
        NavigatorVendor = 124,
        NavigatorVendorSub = 125,
        FileError = 126,
        PrefixedAnimationEndEvent = 128,
        UnprefixedAnimationEndEvent = 129,
        PrefixedAndUnprefixedAnimationEndEvent = 130,
        PrefixedAnimationStartEvent = 131,
        UnprefixedAnimationStartEvent = 132,
        PrefixedAndUnprefixedAnimationStartEvent = 133,
        PrefixedAnimationIterationEvent = 134,
        UnprefixedAnimationIterationEvent = 135,
        PrefixedAndUnprefixedAnimationIterationEvent = 136,
        EventReturnValue = 137, // Legacy IE extension.
        SVGSVGElement = 138,
        DOMSubtreeModifiedEvent = 143,
        DOMNodeInsertedEvent = 144,
        DOMNodeRemovedEvent = 145,
        DOMNodeRemovedFromDocumentEvent = 146,
        DOMNodeInsertedIntoDocumentEvent = 147,
        DOMCharacterDataModifiedEvent = 148,
        DocumentAllLegacyCall = 150,
        HTMLEmbedElementLegacyCall = 152,
        HTMLObjectElementLegacyCall = 153,
        GetMatchedCSSRules = 155,
        AttributeOwnerElement = 160,
        AttributeSpecified = 162,
        PrefixedAudioDecodedByteCount = 164,
        PrefixedVideoDecodedByteCount = 165,
        PrefixedVideoSupportsFullscreen = 166,
        PrefixedVideoDisplayingFullscreen = 167,
        PrefixedVideoEnterFullscreen = 168,
        PrefixedVideoExitFullscreen = 169,
        PrefixedVideoEnterFullScreen = 170,
        PrefixedVideoExitFullScreen = 171,
        PrefixedVideoDecodedFrameCount = 172,
        PrefixedVideoDroppedFrameCount = 173,
        PrefixedElementRequestFullscreen = 176,
        PrefixedElementRequestFullScreen = 177,
        BarPropLocationbar = 178,
        BarPropMenubar = 179,
        BarPropPersonalbar = 180,
        BarPropScrollbars = 181,
        BarPropStatusbar = 182,
        BarPropToolbar = 183,
        InputTypeEmailMultiple = 184,
        InputTypeEmailMaxLength = 185,
        InputTypeEmailMultipleMaxLength = 186,
        InputTypeText = 190,
        InputTypeTextMaxLength = 191,
        InputTypePassword = 192,
        InputTypePasswordMaxLength = 193,
        PrefixedPageVisibility = 196,
        CSSStyleSheetInsertRuleOptionalArg = 198, // Inconsistent with the specification and other browsers.
        DocumentBeforeUnloadRegistered = 200,
        DocumentBeforeUnloadFired = 201,
        DocumentUnloadRegistered = 202,
        DocumentUnloadFired = 203,
        SVGLocatableNearestViewportElement = 204,
        SVGLocatableFarthestViewportElement = 205,
        SVGPointMatrixTransform = 209,
        DOMFocusInOutEvent = 211,
        FileGetLastModifiedDate = 212,
        HTMLElementInnerText = 213,
        HTMLElementOuterText = 214,
        ReplaceDocumentViaJavaScriptURL = 215,
        ElementPrefixedMatchesSelector = 217,
        CSSStyleSheetRules = 219,
        CSSStyleSheetAddRule = 220,
        CSSStyleSheetRemoveRule = 221,
        // The above items are available in M33 branch.

        InitMessageEvent = 222,
        PrefixedDevicePixelRatioMediaFeature = 233,
        PrefixedMaxDevicePixelRatioMediaFeature = 234,
        PrefixedMinDevicePixelRatioMediaFeature = 235,
        PrefixedTransform3dMediaFeature = 237,
        PrefixedStorageQuota = 240,
        ResetReferrerPolicy = 243,
        CaseInsensitiveAttrSelectorMatch = 244, // Case-insensitivity dropped from specification.
        FormNameAccessForImageElement = 246,
        FormNameAccessForPastNamesMap = 247,
        FormAssociationByParser = 248,
        SVGSVGElementInDocument = 250,
        SVGDocumentRootElement = 251,
        WorkerSubjectToCSP = 257,
        WorkerAllowedByChildBlockedByScript = 258,
        DeprecatedWebKitGradient = 260,
        DeprecatedWebKitLinearGradient = 261,
        DeprecatedWebKitRepeatingLinearGradient = 262,
        DeprecatedWebKitRadialGradient = 263,
        DeprecatedWebKitRepeatingRadialGradient = 264,
        PrefixedImageSmoothingEnabled = 267,
        UnprefixedImageSmoothingEnabled = 268,
        // The above items are available in M34 branch.

        TextAutosizing = 274,
        HTMLAnchorElementPingAttribute = 276,
        SVGClassName = 279,
        HTMLMediaElementSeekToFragmentStart = 281,
        HTMLMediaElementPauseAtFragmentEnd = 282,
        PrefixedWindowURL = 283,
        WindowOrientation = 285,
        DOMStringListContains = 286,
        DocumentCaptureEvents = 287,
        DocumentReleaseEvents = 288,
        WindowCaptureEvents = 289,
        WindowReleaseEvents = 290,
        DocumentXPathCreateExpression = 295,
        DocumentXPathCreateNSResolver = 296,
        DocumentXPathEvaluate = 297,
        AttrGetValue = 298,
        AttrSetValue = 299,
        AnimationConstructorKeyframeListEffectObjectTiming = 300,
        AnimationConstructorKeyframeListEffectNoTiming = 302,
        AttrSetValueWithElement = 303,
        PrefixedCancelAnimationFrame = 304,
        PrefixedCancelRequestAnimationFrame = 305,
        NamedNodeMapGetNamedItem = 306,
        NamedNodeMapSetNamedItem = 307,
        NamedNodeMapRemoveNamedItem = 308,
        NamedNodeMapItem = 309,
        NamedNodeMapGetNamedItemNS = 310,
        NamedNodeMapSetNamedItemNS = 311,
        NamedNodeMapRemoveNamedItemNS = 312,
        PrefixedDocumentIsFullscreen = 318,
        PrefixedDocumentCurrentFullScreenElement = 320,
        PrefixedDocumentCancelFullScreen = 321,
        PrefixedDocumentFullscreenEnabled = 322,
        PrefixedDocumentFullscreenElement = 323,
        PrefixedDocumentExitFullscreen = 324,
        // The above items are available in M35 branch.

        SVGForeignObjectElement = 325,
        SelectionSetPosition = 327,
        AnimationFinishEvent = 328,
        SVGSVGElementInXMLDocument = 329,
        PrefixedPerformanceClearResourceTimings = 341,
        PrefixedPerformanceSetResourceTimingBufferSize = 342,
        EventSrcElement = 343,
        EventCancelBubble = 344,
        EventPath = 345,
        NodeIteratorDetach = 347,
        AttrNodeValue = 348,
        AttrTextContent = 349,
        EventGetReturnValueTrue = 350,
        EventGetReturnValueFalse = 351,
        EventSetReturnValueTrue = 352,
        EventSetReturnValueFalse = 353,
        WindowOffscreenBuffering = 356,
        WindowDefaultStatus = 357,
        WindowDefaultstatus = 358,
        PrefixedTransitionEventConstructor = 361,
        PrefixedMutationObserverConstructor = 362,
        PrefixedIDBCursorConstructor = 363,
        PrefixedIDBDatabaseConstructor = 364,
        PrefixedIDBFactoryConstructor = 365,
        PrefixedIDBIndexConstructor = 366,
        PrefixedIDBKeyRangeConstructor = 367,
        PrefixedIDBObjectStoreConstructor = 368,
        PrefixedIDBRequestConstructor = 369,
        PrefixedIDBTransactionConstructor = 370,
        NotificationPermission = 371,
        RangeDetach = 372,
        PrefixedFileRelativePath = 386,
        DocumentCaretRangeFromPoint = 387,
        ElementScrollIntoViewIfNeeded = 389,
        RangeExpand = 393,
        HTMLImageElementX = 396,
        HTMLImageElementY = 397,
        SelectionBaseNode = 400,
        SelectionBaseOffset = 401,
        SelectionExtentNode = 402,
        SelectionExtentOffset = 403,
        SelectionType = 404,
        SelectionModify = 405,
        SelectionSetBaseAndExtent = 406,
        SelectionEmpty = 407,
        VTTCue = 409,
        VTTCueRender = 410,
        VTTCueRenderVertical = 411,
        VTTCueRenderSnapToLinesFalse = 412,
        VTTCueRenderLineNotAuto = 413,
        VTTCueRenderPositionNot50 = 414,
        VTTCueRenderSizeNot100 = 415,
        VTTCueRenderAlignNotMiddle = 416,
        // The above items are available in M36 branch.

        ElementRequestPointerLock = 417,
        VTTCueRenderRtl = 418,
        PostMessageFromSecureToInsecure = 419,
        PostMessageFromInsecureToSecure = 420,
        DocumentExitPointerLock = 421,
        DocumentPointerLockElement = 422,
        PrefixedCursorZoomIn = 424,
        PrefixedCursorZoomOut = 425,
        TextEncoderConstructor = 429,
        TextEncoderEncode = 430,
        TextDecoderConstructor = 431,
        TextDecoderDecode = 432,
        FocusInOutEvent = 433,
        MouseEventMovementX = 434,
        MouseEventMovementY = 435,
        DocumentFonts = 440,
        MixedContentFormsSubmitted = 441,
        FormsSubmitted = 442,
        TextInputEventOnInput = 443,
        TextInputEventOnTextArea = 444,
        TextInputEventOnContentEditable = 445,
        TextInputEventOnNotNode = 446,
        WebkitBeforeTextInsertedOnInput = 447,
        WebkitBeforeTextInsertedOnTextArea = 448,
        WebkitBeforeTextInsertedOnContentEditable = 449,
        WebkitBeforeTextInsertedOnNotNode = 450,
        WebkitEditableContentChangedOnInput = 451,
        WebkitEditableContentChangedOnTextArea = 452,
        WebkitEditableContentChangedOnContentEditable = 453,
        WebkitEditableContentChangedOnNotNode = 454,
        HTMLImports = 455,
        ElementCreateShadowRoot = 456,
        DocumentRegisterElement = 457,
        EditingAppleInterchangeNewline = 458,
        EditingAppleConvertedSpace = 459,
        EditingApplePasteAsQuotation = 460,
        EditingAppleStyleSpanClass = 461,
        EditingAppleTabSpanClass = 462,
        HTMLImportsAsyncAttribute = 463,
        XMLHttpRequestSynchronous = 465,
        CSSSelectorPseudoUnresolved = 466,
        CSSSelectorPseudoShadow = 467,
        CSSSelectorPseudoContent = 468,
        CSSSelectorPseudoHost = 469,
        CSSSelectorPseudoHostContext = 470,
        CSSDeepCombinator = 471,
        // The above items are available in M37 branch.

        UseAsm = 473,
        DOMWindowOpen = 475,
        DOMWindowOpenFeatures = 476,
        MediaStreamTrackGetSources = 478,
        AspectRatioFlexItem = 479,
        DetailsElement = 480,
        DialogElement = 481,
        MapElement = 482,
        MeterElement = 483,
        ProgressElement = 484,
        PrefixedHTMLElementDropzone = 490,
        WheelEventWheelDeltaX = 491,
        WheelEventWheelDeltaY = 492,
        WheelEventWheelDelta = 493,
        SendBeacon = 494,
        SendBeaconQuotaExceeded = 495,
        SVGSMILElementInDocument = 501,
        MouseEventOffsetX = 502,
        MouseEventOffsetY = 503,
        MouseEventX = 504,
        MouseEventY = 505,
        MouseEventFromElement = 506,
        MouseEventToElement = 507,
        RequestFileSystem = 508,
        RequestFileSystemWorker = 509,
        RequestFileSystemSyncWorker = 510,
        DevToolsConsoleProfile = 518,
        SVGStyleElementTitle = 519,
        PictureSourceSrc = 520,
        // The above items are available in M38 branch.

        Picture = 521,
        Sizes = 522,
        SrcsetXDescriptor = 523,
        SrcsetWDescriptor = 524,
        SelectionContainsNode = 525,
        XMLExternalResourceLoad = 529,
        MixedContentPrivateHostnameInPublicHostname = 530,
        LegacyProtocolEmbeddedAsSubresource = 531,
        RequestedSubresourceWithEmbeddedCredentials = 532,
        NotificationCreated = 533,
        NotificationClosed = 534,
        NotificationPermissionRequested = 535,
        ConsoleTimeline = 538,
        ConsoleTimelineEnd = 539,
        SRIElementWithMatchingIntegrityAttribute = 540,
        SRIElementWithNonMatchingIntegrityAttribute = 541,
        SRIElementWithUnparsableIntegrityAttribute = 542,
        V8Animation_StartTime_AttributeGetter = 545,
        V8Animation_StartTime_AttributeSetter = 546,
        V8Animation_CurrentTime_AttributeGetter = 547,
        V8Animation_CurrentTime_AttributeSetter = 548,
        V8Animation_PlaybackRate_AttributeGetter = 549,
        V8Animation_PlaybackRate_AttributeSetter = 550,
        V8Animation_PlayState_AttributeGetter = 551,
        V8Animation_Finish_Method = 552,
        V8Animation_Play_Method = 553,
        V8Animation_Pause_Method = 554,
        V8Animation_Reverse_Method = 555,
        // The above items are available in M39 branch.

        BreakIterator = 556,
        ScreenOrientationAngle = 557,
        ScreenOrientationType = 558,
        ScreenOrientationLock = 559,
        ScreenOrientationUnlock = 560,
        GeolocationSecureOrigin = 561,
        GeolocationInsecureOrigin = 562,
        NotificationSecureOrigin = 563,
        NotificationInsecureOrigin = 564,
        NotificationShowEvent = 565,
        SVGTransformListConsolidate = 569,
        SVGAnimatedTransformListBaseVal = 570,
        QuotedAnimationName = 571,
        QuotedKeyframesRule = 572,
        SrcsetDroppedCandidate = 573,
        WindowPostMessage = 574,
        WindowPostMessageWithLegacyTargetOriginArgument = 575,
        RenderRuby = 576,
        ScriptElementWithInvalidTypeHasSrc = 578,
        XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload = 581,
        CSSSelectorPseudoScrollbar = 582,
        CSSSelectorPseudoScrollbarButton = 583,
        CSSSelectorPseudoScrollbarThumb = 584,
        CSSSelectorPseudoScrollbarTrack = 585,
        CSSSelectorPseudoScrollbarTrackPiece = 586,
        LangAttribute = 587,
        LangAttributeOnHTML = 588,
        LangAttributeOnBody = 589,
        LangAttributeDoesNotMatchToUILocale = 590,
        InputTypeSubmit = 591,
        InputTypeSubmitWithValue = 592,
        // The above items are available in M40 branch.

        SetReferrerPolicy = 593,
        MouseEventWhich = 595,
        UIEventWhich = 598,
        TextWholeText = 599,
        NotificationCloseEvent = 603,
        StyleMedia = 606,
        StyleMediaType = 607,
        StyleMediaMatchMedium = 608,
        MixedContentPresent = 609,
        MixedContentBlockable = 610,
        MixedContentAudio = 611,
        MixedContentDownload = 612,
        MixedContentFavicon = 613,
        MixedContentImage = 614,
        MixedContentInternal = 615,
        MixedContentPlugin = 616,
        MixedContentPrefetch = 617,
        MixedContentVideo = 618,
        AudioListenerDopplerFactor = 620,
        AudioListenerSpeedOfSound = 621,
        AudioListenerSetVelocity = 622,
        CSSSelectorPseudoFullScreenAncestor = 628,
        CSSSelectorPseudoFullScreen = 629,
        WebKitCSSMatrix = 630,
        AudioContextCreateAnalyser = 631,
        AudioContextCreateBiquadFilter = 632,
        AudioContextCreateBufferSource = 633,
        AudioContextCreateChannelMerger = 634,
        AudioContextCreateChannelSplitter = 635,
        AudioContextCreateConvolver = 636,
        AudioContextCreateDelay = 637,
        AudioContextCreateDynamicsCompressor = 638,
        AudioContextCreateGain = 639,
        AudioContextCreateMediaElementSource = 640,
        AudioContextCreateMediaStreamDestination = 641,
        AudioContextCreateMediaStreamSource = 642,
        AudioContextCreateOscillator = 643,
        AudioContextCreatePanner = 644,
        AudioContextCreatePeriodicWave = 645,
        AudioContextCreateScriptProcessor = 646,
        AudioContextCreateStereoPanner = 647,
        AudioContextCreateWaveShaper = 648,
        AudioContextDecodeAudioData = 649,
        AudioContextResume = 650,
        AudioContextSuspend = 651,
        AudioContext = 652,
        OfflineAudioContext = 653,
        PrefixedAudioContext = 654,
        PrefixedOfflineAudioContext = 655,
        MixedContentInNonHTTPSFrameThatRestrictsMixedContent = 661,
        MixedContentInSecureFrameThatDoesNotRestrictMixedContent = 662,
        MixedContentWebSocket = 663,
        SyntheticKeyframesInCompositedCSSAnimation = 664,
        MixedContentFormPresent = 665,
        GetUserMediaInsecureOrigin = 666,
        GetUserMediaSecureOrigin = 667,
        // The above items are available in M41 branch.

        DeviceMotionInsecureOrigin = 668,
        DeviceMotionSecureOrigin = 669,
        DeviceOrientationInsecureOrigin = 670,
        DeviceOrientationSecureOrigin = 671,
        SandboxViaIFrame = 672,
        SandboxViaCSP = 673,
        BlockedSniffingImageToScript = 674,
        Fetch = 675,
        FetchBodyStream = 676,
        XMLHttpRequestAsynchronous = 677,
        WhiteSpacePreFromXMLSpace = 679,
        WhiteSpaceNowrapFromXMLSpace = 680,
        SVGSVGElementForceRedraw = 685,
        SVGSVGElementSuspendRedraw = 686,
        SVGSVGElementUnsuspendRedraw = 687,
        SVGSVGElementUnsuspendRedrawAll = 688,
        AudioContextClose = 689,
        CSSZoomNotEqualToOne = 691,
        // The above items are available in M42 branch.

        ClientRectListItem = 694,
        WindowClientInformation = 695,
        WindowFind = 696,
        WindowScreenLeft = 697,
        WindowScreenTop = 698,
        V8Animation_Cancel_Method = 699,
        V8Animation_Onfinish_AttributeGetter = 700,
        V8Animation_Onfinish_AttributeSetter = 701,
        V8Window_WebKitAnimationEvent_ConstructorGetter = 707,
        V8Window_WebKitAnimationEvent_AttributeSetter = 708,
        CryptoGetRandomValues = 710,
        SubtleCryptoEncrypt = 711,
        SubtleCryptoDecrypt = 712,
        SubtleCryptoSign = 713,
        SubtleCryptoVerify = 714,
        SubtleCryptoDigest = 715,
        SubtleCryptoGenerateKey = 716,
        SubtleCryptoImportKey = 717,
        SubtleCryptoExportKey = 718,
        SubtleCryptoDeriveBits = 719,
        SubtleCryptoDeriveKey = 720,
        SubtleCryptoWrapKey = 721,
        SubtleCryptoUnwrapKey = 722,
        CryptoAlgorithmAesCbc = 723,
        CryptoAlgorithmHmac = 724,
        CryptoAlgorithmRsaSsaPkcs1v1_5 = 725,
        CryptoAlgorithmSha1 = 726,
        CryptoAlgorithmSha256 = 727,
        CryptoAlgorithmSha384 = 728,
        CryptoAlgorithmSha512 = 729,
        CryptoAlgorithmAesGcm = 730,
        CryptoAlgorithmRsaOaep = 731,
        CryptoAlgorithmAesCtr = 732,
        CryptoAlgorithmAesKw = 733,
        CryptoAlgorithmRsaPss = 734,
        CryptoAlgorithmEcdsa = 735,
        CryptoAlgorithmEcdh = 736,
        CryptoAlgorithmHkdf = 737,
        CryptoAlgorithmPbkdf2 = 738,
        DocumentSetDomain = 739,
        UpgradeInsecureRequestsEnabled = 740,
        UpgradeInsecureRequestsUpgradedRequest = 741,
        DocumentDesignMode = 742,
        GlobalCacheStorage = 743,
        NetInfo = 744,
        BackgroundSync = 745,
        LegacyConst = 748,
        V8Permissions_Query_Method = 750,
        // The above items are available in M43 branch.

        V8HTMLInputElement_Autocapitalize_AttributeGetter = 754,
        V8HTMLInputElement_Autocapitalize_AttributeSetter = 755,
        V8HTMLTextAreaElement_Autocapitalize_AttributeGetter = 756,
        V8HTMLTextAreaElement_Autocapitalize_AttributeSetter = 757,
        SVGHrefBaseVal = 758,
        SVGHrefAnimVal = 759,
        V8CSSRuleList_Item_Method = 760,
        V8MediaList_Item_Method = 761,
        V8StyleSheetList_Item_Method = 762,
        StyleSheetListAnonymousNamedGetter = 763,
        AutocapitalizeAttribute = 764,
        FullscreenSecureOrigin = 765,
        FullscreenInsecureOrigin = 766,
        DialogInSandboxedContext = 767,
        SVGSMILAnimationInImageRegardlessOfCache = 768,
        EncryptedMediaSecureOrigin = 770,
        EncryptedMediaInsecureOrigin = 771,
        PerformanceFrameTiming = 772,
        V8Element_Animate_Method = 773,
        // The above items are available in M44 branch.

        V8SVGSVGElement_GetElementById_Method = 778,
        ElementCreateShadowRootMultiple = 779,
        V8MessageChannel_Constructor = 780,
        V8MessagePort_PostMessage_Method = 781,
        V8MessagePort_Start_Method = 782,
        V8MessagePort_Close_Method = 783,
        MessagePortsTransferred = 784,
        CSSKeyframesRuleAnonymousIndexedGetter = 785,
        V8Screen_AvailLeft_AttributeGetter = 786,
        V8Screen_AvailTop_AttributeGetter = 787,
        ObjectObserve = 788,
        V8SVGFEConvolveMatrixElement_PreserveAlpha_AttributeGetter = 791,
        V8SVGStyleElement_Disabled_AttributeGetter = 798,
        V8SVGStyleElement_Disabled_AttributeSetter = 799,
        InputTypeFileSecureOrigin = 801,
        InputTypeFileInsecureOrigin = 802,
        ElementAttachShadow = 804,
        V8KeyboardEvent_KeyIdentifier_AttributeGetter = 805,
        V8SecurityPolicyViolationEvent_DocumentURI_AttributeGetter = 806,
        V8SecurityPolicyViolationEvent_BlockedURI_AttributeGetter = 807,
        V8SecurityPolicyViolationEvent_StatusCode_AttributeGetter = 808,
        HTMLLinkElementDisabled = 809,
        V8HTMLLinkElement_Disabled_AttributeGetter = 810,
        V8HTMLLinkElement_Disabled_AttributeSetter = 811,
        V8HTMLStyleElement_Disabled_AttributeGetter = 812,
        V8HTMLStyleElement_Disabled_AttributeSetter = 813,
        V8FileReader_ReadAsBinaryString_Method = 814,
        V8FileReaderSync_ReadAsBinaryString_Method = 815,
        V8DOMError_Constructor = 816,
        V8DOMError_Name_AttributeGetter = 817,
        V8DOMError_Message_AttributeGetter = 818,
        V8FileReader_Error_AttributeGetter = 819,
        V8Location_AncestorOrigins_AttributeGetter = 823,
        V8IDBDatabase_ObjectStoreNames_AttributeGetter = 824,
        V8IDBObjectStore_IndexNames_AttributeGetter = 825,
        V8IDBTransaction_ObjectStoreNames_AttributeGetter = 826,
        TextInputFired = 830,
        V8TextEvent_Data_AttributeGetter = 831,
        V8TextEvent_InitTextEvent_Method = 832,
        V8SVGSVGElement_UseCurrentView_AttributeGetter = 833,
        V8SVGSVGElement_CurrentView_AttributeGetter = 834,
        ClientHintsDPR = 835,
        ClientHintsResourceWidth = 836,
        ClientHintsViewportWidth = 837,
        SRIElementIntegrityAttributeButIneligible = 838,
        FormDataAppendFile = 839,
        FormDataAppendFileWithFilename = 840,
        FormDataAppendBlob = 841,
        FormDataAppendBlobWithFilename = 842,
        FormDataAppendNull = 843,
        HTMLDocumentCreateAttributeNameNotLowercase = 844,
        NonHTMLElementSetAttributeNodeFromHTMLDocumentNameNotLowercase = 845,
        DOMStringList_Item_AttributeGetter_IndexedDB = 846,
        DOMStringList_Item_AttributeGetter_Location = 847,
        DOMStringList_Contains_Method_IndexedDB = 848,
        DOMStringList_Contains_Method_Location = 849,
        NavigatorVibrate = 850,
        NavigatorVibrateSubFrame = 851,
        V8XPathEvaluator_Constructor = 853,
        V8XPathEvaluator_CreateExpression_Method = 854,
        V8XPathEvaluator_CreateNSResolver_Method = 855,
        V8XPathEvaluator_Evaluate_Method = 856,
        RequestMIDIAccess = 857,
        V8MouseEvent_LayerX_AttributeGetter = 858,
        V8MouseEvent_LayerY_AttributeGetter = 859,
        InnerTextWithShadowTree = 860,
        SelectionToStringWithShadowTree = 861,
        WindowFindWithShadowTree = 862,
        V8CompositionEvent_InitCompositionEvent_Method = 863,
        V8CustomEvent_InitCustomEvent_Method = 864,
        V8DeviceMotionEvent_InitDeviceMotionEvent_Method = 865,
        V8DeviceOrientationEvent_InitDeviceOrientationEvent_Method = 866,
        V8Event_InitEvent_Method = 867,
        V8KeyboardEvent_InitKeyboardEvent_Method = 868,
        V8MouseEvent_InitMouseEvent_Method = 869,
        V8MutationEvent_InitMutationEvent_Method = 870,
        V8StorageEvent_InitStorageEvent_Method = 871,
        V8TouchEvent_InitTouchEvent_Method = 872,
        V8UIEvent_InitUIEvent_Method = 873,
        V8Document_CreateTouch_Method = 874,
        RequestFileSystemNonWebbyOrigin = 876,
        V8Console_Memory_AttributeGetter = 877,
        V8Console_Memory_AttributeSetter = 878,
        V8MemoryInfo_TotalJSHeapSize_AttributeGetter = 879,
        V8MemoryInfo_UsedJSHeapSize_AttributeGetter = 880,
        V8MemoryInfo_JSHeapSizeLimit_AttributeGetter = 881,
        V8Performance_Timing_AttributeGetter = 882,
        V8Performance_Navigation_AttributeGetter = 883,
        V8Performance_Memory_AttributeGetter = 884,
        V8SharedWorker_WorkerStart_AttributeGetter = 885,
        HTMLKeygenElement = 886,
        // The above items are available in M45 branch.

        HTMLMediaElementPreloadNone = 892,
        HTMLMediaElementPreloadMetadata = 893,
        HTMLMediaElementPreloadAuto = 894,
        HTMLMediaElementPreloadDefault = 895,
        MixedContentBlockableAllowed = 896,
        PseudoBeforeAfterForInputElement = 897,
        V8Permissions_Revoke_Method = 898,
        LinkRelDnsPrefetch = 899,
        LinkRelPreconnect = 900,
        LinkRelPreload = 901,
        LinkHeaderDnsPrefetch = 902,
        LinkHeaderPreconnect = 903,
        ClientHintsMetaAcceptCH = 904,
        HTMLElementDeprecatedWidth = 905,
        ClientHintsContentDPR = 906,
        ElementAttachShadowOpen = 907,
        ElementAttachShadowClosed = 908,
        AudioParamSetValueAtTime = 909,
        AudioParamLinearRampToValueAtTime = 910,
        AudioParamExponentialRampToValueAtTime = 911,
        AudioParamSetTargetAtTime = 912,
        AudioParamSetValueCurveAtTime = 913,
        AudioParamCancelScheduledValues = 914,
        V8Permissions_Request_Method = 915,
        LinkRelPrefetch = 917,
        LinkRelPrerender = 918,
        LinkRelNext = 919,
        PrefixedPerformanceResourceTimingBufferFull = 920,
        CSSValuePrefixedMinContent = 921,
        CSSValuePrefixedMaxContent = 922,
        CSSValuePrefixedFitContent = 923,
        CSSValuePrefixedFillAvailable = 924,
        PresentationDefaultRequest = 926,
        PresentationAvailabilityChangeEventListener = 927,
        PresentationRequestConstructor = 928,
        PresentationRequestStart = 929,
        PresentationRequestReconnect = 930,
        PresentationRequestGetAvailability = 931,
        PresentationRequestConnectionAvailableEventListener = 932,
        PresentationConnectionTerminate = 933,
        PresentationConnectionSend = 934,
        PresentationConnectionMessageEventListener = 936,
        CSSAnimationsStackedNeutralKeyframe = 937,
        ReadingCheckedInClickHandler = 938,
        FlexboxIntrinsicSizeAlgorithmIsDifferent = 939,
        // The above items are available in M46 branch.

        HTMLImportsHasStyleSheets = 940,
        ClipPathOfPositionedElement = 944,
        ClipCssOfPositionedElement = 945,
        NetInfoType = 946,
        NetInfoDownlinkMax = 947,
        NetInfoOnChange = 948,
        NetInfoOnTypeChange = 949,
        V8Window_Alert_Method = 950,
        V8Window_Confirm_Method = 951,
        V8Window_Prompt_Method = 952,
        V8Window_Print_Method = 953,
        V8Window_RequestIdleCallback_Method = 954,
        FlexboxPercentagePaddingVertical = 955,
        FlexboxPercentageMarginVertical = 956,
        BackspaceNavigatedBack = 957,
        BackspaceNavigatedBackAfterFormInteraction = 958,
        CSPSourceWildcardWouldMatchExactHost = 959,
        CredentialManagerGet = 960,
        CredentialManagerGetWithUI = 961,
        CredentialManagerGetWithoutUI = 962,
        CredentialManagerStore = 963,
        CredentialManagerRequireUserMediation = 964,
        // The above items are available in M47 branch.

        RequestAutocomplete = 965,
        BlockableMixedContentInSubframeBlocked = 966,
        AddEventListenerThirdArgumentIsObject = 967,
        RemoveEventListenerThirdArgumentIsObject = 968,
        CSSAtRuleCharset = 969,
        CSSAtRuleFontFace = 970,
        CSSAtRuleImport = 971,
        CSSAtRuleKeyframes = 972,
        CSSAtRuleMedia = 973,
        CSSAtRuleNamespace = 974,
        CSSAtRulePage = 975,
        CSSAtRuleSupports = 976,
        CSSAtRuleViewport = 977,
        CSSAtRuleWebkitKeyframes = 978,
        V8HTMLFieldSetElement_Elements_AttributeGetter = 979,
        HTMLMediaElementPreloadForcedNone = 980,
        ExternalAddSearchProvider = 981,
        ExternalIsSearchProviderInstalled = 982,
        V8Permissions_RequestAll_Method = 983,
        DeviceOrientationAbsoluteInsecureOrigin = 987,
        DeviceOrientationAbsoluteSecureOrigin = 988,
        FontFaceConstructor = 989,
        ServiceWorkerControlledPage = 990,
        MeterElementWithMeterAppearance = 993,
        MeterElementWithNoneAppearance = 994,
        SelectionAnchorNode = 997,
        SelectionAnchorOffset = 998,
        SelectionFocusNode = 999,
        SelectionFocusOffset = 1000,
        SelectionIsCollapsed = 1001,
        SelectionRangeCount = 1002,
        SelectionGetRangeAt = 1003,
        SelectionAddRange = 1004,
        SelectionRemoveAllRanges = 1005,
        SelectionCollapse = 1006,
        SelectionCollapseToStart = 1007,
        SelectionCollapseToEnd = 1008,
        SelectionExtend = 1009,
        SelectionSelectAllChildren = 1010,
        SelectionDeleteDromDocument = 1011,
        SelectionDOMString = 1012,
        InputTypeRangeVerticalAppearance = 1013,
        // The above items are available in M48 branch.

        CSSFilterReference = 1014,
        CSSFilterGrayscale = 1015,
        CSSFilterSepia = 1016,
        CSSFilterSaturate = 1017,
        CSSFilterHueRotate = 1018,
        CSSFilterInvert = 1019,
        CSSFilterOpacity = 1020,
        CSSFilterBrightness = 1021,
        CSSFilterContrast = 1022,
        CSSFilterBlur = 1023,
        CSSFilterDropShadow = 1024,
        BackgroundSyncRegister = 1025,
        BorderImageWithBorderStyleNone = 1026,
        ExecCommandOnInputOrTextarea = 1027,
        V8History_ScrollRestoration_AttributeGetter = 1028,
        V8History_ScrollRestoration_AttributeSetter = 1029,
        SVG1DOMFilter = 1030,
        OfflineAudioContextStartRendering = 1031,
        OfflineAudioContextSuspend = 1032,
        OfflineAudioContextResume = 1033,
        AttrCloneNode = 1034,
        SVG1DOMPaintServer = 1035,
        SVGSVGElementFragmentSVGView = 1036,
        SVGSVGElementFragmentSVGViewElement = 1037,
        PresentationConnectionClose = 1038,
        SVG1DOMShape = 1039,
        SVG1DOMText = 1040,
        RTCPeerConnectionConstructorConstraints = 1041,
        RTCPeerConnectionConstructorCompliant = 1042,
        RTCPeerConnectionCreateOfferLegacyFailureCallback = 1044,
        RTCPeerConnectionCreateOfferLegacyConstraints = 1045,
        RTCPeerConnectionCreateOfferLegacyOfferOptions = 1046,
        RTCPeerConnectionCreateOfferLegacyCompliant = 1047,
        RTCPeerConnectionCreateAnswerLegacyFailureCallback = 1049,
        RTCPeerConnectionCreateAnswerLegacyConstraints = 1050,
        RTCPeerConnectionCreateAnswerLegacyCompliant = 1051,
        RTCPeerConnectionSetLocalDescriptionLegacyNoSuccessCallback = 1052,
        RTCPeerConnectionSetLocalDescriptionLegacyNoFailureCallback = 1053,
        RTCPeerConnectionSetLocalDescriptionLegacyCompliant = 1054,
        RTCPeerConnectionSetRemoteDescriptionLegacyNoSuccessCallback = 1055,
        RTCPeerConnectionSetRemoteDescriptionLegacyNoFailureCallback = 1056,
        RTCPeerConnectionSetRemoteDescriptionLegacyCompliant = 1057,
        RTCPeerConnectionGetStatsLegacyNonCompliant = 1058,
        NodeFilterIsFunction = 1059,
        NodeFilterIsObject = 1060,
        TextEncoderUTF16 = 1061,
        CSSSelectorInternalPseudoListBox = 1062,
        CSSSelectorInternalMediaControlsCastButton = 1063,
        CSSSelectorInternalMediaControlsOverlayCastButton = 1064,
        CSSSelectorInternalPseudoSpatialNavigationFocus = 1065,
        SameOriginTextScript = 1066,
        SameOriginApplicationScript = 1067,
        SameOriginOtherScript = 1068,
        CrossOriginTextScript = 1069,
        CrossOriginApplicationScript = 1070,
        CrossOriginOtherScript = 1071,
        SVG1DOMSVGTests = 1072,
        V8SVGViewElement_ViewTarget_AttributeGetter = 1073,
        DisableRemotePlaybackAttribute = 1074,
        V8SloppyMode = 1075,
        V8StrictMode = 1076,
        V8StrongMode = 1077,
        AudioNodeConnectToAudioNode = 1078,
        AudioNodeConnectToAudioParam = 1079,
        AudioNodeDisconnectFromAudioNode = 1080,
        AudioNodeDisconnectFromAudioParam = 1081,
        V8CSSFontFaceRule_Style_AttributeGetter = 1082,
        SelectionCollapseNull = 1083,
        SelectionSetBaseAndExtentNull = 1084,
        V8SVGSVGElement_CreateSVGNumber_Method = 1085,
        V8SVGSVGElement_CreateSVGLength_Method = 1086,
        V8SVGSVGElement_CreateSVGAngle_Method = 1087,
        V8SVGSVGElement_CreateSVGPoint_Method = 1088,
        V8SVGSVGElement_CreateSVGMatrix_Method = 1089,
        V8SVGSVGElement_CreateSVGRect_Method = 1090,
        V8SVGSVGElement_CreateSVGTransform_Method = 1091,
        V8SVGSVGElement_CreateSVGTransformFromMatrix_Method = 1092,
        FormNameAccessForNonDescendantImageElement = 1093,
        V8SVGSVGElement_Viewport_AttributeGetter = 1095,
        V8RegExpPrototypeStickyGetter = 1096,
        V8RegExpPrototypeToString = 1097,
        V8InputDeviceCapabilities_FiresTouchEvents_AttributeGetter = 1098,
        DataElement = 1099,
        TimeElement = 1100,
        SVG1DOMUriReference = 1101,
        SVG1DOMZoomAndPan = 1102,
        V8SVGGraphicsElement_Transform_AttributeGetter = 1103,
        MenuItemElement = 1104,
        MenuItemCloseTag = 1105,
        SVG1DOMMarkerElement = 1106,
        SVG1DOMUseElement = 1107,
        SVG1DOMMaskElement = 1108,
        V8SVGAElement_Target_AttributeGetter = 1109,
        V8SVGClipPathElement_ClipPathUnits_AttributeGetter = 1110,
        SVG1DOMFitToViewBox = 1111,
        SVG1DOMCursorElement = 1112,
        V8SVGPathElement_PathLength_AttributeGetter = 1113,
        SVG1DOMSVGElement = 1114,
        SVG1DOMImageElement = 1115,
        SVG1DOMForeignObjectElement = 1116,
        AudioContextCreateIIRFilter = 1117,
        // The above items are available in M49 branch

        CSSSelectorPseudoSlotted = 1118,
        MediaDevicesEnumerateDevices = 1119,
        NonSecureSharedWorkerAccessedFromSecureContext = 1120,
        SecureSharedWorkerAccessedFromNonSecureContext = 1121,
        EventComposedPath = 1123,
        LinkHeaderPreload = 1124,
        MouseWheelEvent = 1125,
        WheelEvent = 1126,
        MouseWheelAndWheelEvent = 1127,
        BodyScrollsInAdditionToViewport = 1128,
        DocumentDesignModeEnabeld = 1129,
        ContentEditableTrue = 1130,
        ContentEditableTrueOnHTML = 1131,
        ContentEditablePlainTextOnly = 1132,
        V8RegExpPrototypeUnicodeGetter = 1133,
        V8IntlV8Parse = 1134,
        V8IntlPattern = 1135,
        V8IntlResolved = 1136,
        V8PromiseChain = 1137,
        V8PromiseAccept = 1138,
        V8PromiseDefer = 1139,
        EventComposed = 1140,
        GeolocationInsecureOriginIframe = 1141,
        GeolocationSecureOriginIframe = 1142,
        RequestMIDIAccessIframe = 1143,
        GetUserMediaInsecureOriginIframe = 1144,
        GetUserMediaSecureOriginIframe = 1145,
        ElementRequestPointerLockIframe = 1146,
        NotificationAPIInsecureOriginIframe = 1147,
        NotificationAPISecureOriginIframe = 1148,
        WebSocket = 1149,
        MediaStreamConstraintsNameValue = 1150,
        MediaStreamConstraintsFromDictionary = 1151,
        MediaStreamConstraintsConformant = 1152,
        CSSSelectorIndirectAdjacent = 1153,
        CreateImageBitmap = 1156,
        PresentationConnectionConnectEventListener = 1157,
        PresentationConnectionCloseEventListener = 1158,
        PresentationConnectionTerminateEventListener = 1159,
        DocumentCreateEventFontFaceSetLoadEvent = 1160,
        DocumentCreateEventMediaQueryListEvent = 1161,
        DocumentCreateEventAnimationEvent = 1162,
        DocumentCreateEventAnimationPlayerEvent = 1163,
        DocumentCreateEventApplicationCacheErrorEvent = 1164,
        DocumentCreateEventAutocompleteErrorEvent = 1165,
        DocumentCreateEventBeforeUnloadEvent = 1166,
        DocumentCreateEventClipboardEvent = 1167,
        DocumentCreateEventCompositionEvent = 1168,
        DocumentCreateEventDragEvent = 1169,
        DocumentCreateEventErrorEvent = 1170,
        DocumentCreateEventFocusEvent = 1171,
        DocumentCreateEventHashChangeEvent = 1172,
        DocumentCreateEventMutationEvent = 1173,
        DocumentCreateEventPageTransitionEvent = 1174,
        DocumentCreateEventPointerEvent = 1175,
        DocumentCreateEventPopStateEvent = 1176,
        DocumentCreateEventProgressEvent = 1177,
        DocumentCreateEventPromiseRejectionEvent = 1178,
        DocumentCreateEventRelatedEvent = 1179,
        DocumentCreateEventResourceProgressEvent = 1180,
        DocumentCreateEventSecurityPolicyViolationEvent = 1181,
        DocumentCreateEventTextEvent = 1182,
        DocumentCreateEventTransitionEvent = 1183,
        DocumentCreateEventWheelEvent = 1184,
        DocumentCreateEventTrackEvent = 1186,
        DocumentCreateEventWebKitAnimationEvent = 1187,
        DocumentCreateEventMutationEvents = 1188,
        DocumentCreateEventOrientationEvent = 1189,
        DocumentCreateEventSVGEvents = 1190,
        DocumentCreateEventWebKitTransitionEvent = 1191,
        DocumentCreateEventBeforeInstallPromptEvent = 1192,
        DocumentCreateEventSyncEvent = 1193,
        DocumentCreateEventDeviceLightEvent = 1194,
        DocumentCreateEventDeviceMotionEvent = 1195,
        DocumentCreateEventDeviceOrientationEvent = 1196,
        DocumentCreateEventMediaEncryptedEvent = 1197,
        DocumentCreateEventMediaKeyMessageEvent = 1198,
        DocumentCreateEventGamepadEvent = 1199,
        DocumentCreateEventIDBVersionChangeEvent = 1201,
        DocumentCreateEventBlobEvent = 1202,
        DocumentCreateEventMediaStreamEvent = 1203,
        DocumentCreateEventMediaStreamTrackEvent = 1204,
        DocumentCreateEventRTCDTMFToneChangeEvent = 1205,
        DocumentCreateEventRTCDataChannelEvent = 1206,
        DocumentCreateEventRTCIceCandidateEvent = 1207,
        DocumentCreateEventNotificationEvent = 1209,
        DocumentCreateEventPresentationConnectionAvailableEvent = 1210,
        DocumentCreateEventPresentationConnectionCloseEvent = 1211,
        DocumentCreateEventPushEvent = 1212,
        DocumentCreateEventExtendableEvent = 1213,
        DocumentCreateEventExtendableMessageEvent = 1214,
        DocumentCreateEventFetchEvent = 1215,
        DocumentCreateEventInstallEvent = 1216,
        DocumentCreateEventServiceWorkerMessageEvent = 1217,
        DocumentCreateEventSpeechRecognitionError = 1218,
        DocumentCreateEventSpeechRecognitionEvent = 1219,
        DocumentCreateEventSpeechSynthesisEvent = 1220,
        DocumentCreateEventStorageEvent = 1221,
        DocumentCreateEventAudioProcessingEvent = 1222,
        DocumentCreateEventOfflineAudioCompletionEvent = 1223,
        DocumentCreateEventWebGLContextEvent = 1224,
        DocumentCreateEventMIDIConnectionEvent = 1225,
        DocumentCreateEventMIDIMessageEvent = 1226,
        DocumentCreateEventCloseEvent = 1227,
        DocumentCreateEventKeyboardEvents = 1228,
        HTMLMediaElement = 1229,
        HTMLMediaElementInDocument = 1230,
        HTMLMediaElementControlsAttribute = 1231,
        SVGZoomEvent = 1232,
        V8Animation_Oncancel_AttributeGetter = 1233,
        V8Animation_Oncancel_AttributeSetter = 1234,
        V8HTMLCommentInExternalScript = 1235,
        V8HTMLComment = 1236,
        V8SloppyModeBlockScopedFunctionRedefinition = 1237,
        V8ForInInitializer = 1238,
        V8Animation_Id_AttributeGetter = 1239,
        V8Animation_Id_AttributeSetter = 1240,
        MediaStreamOnEnded = 1241,
        DocumentCreateEventInputEvent = 1242,
        WebAnimationHyphenatedProperty = 1243,
        FormControlsCollectionReturnsRadioNodeListForFieldSet = 1244,
        ApplicationCacheManifestSelectInsecureOrigin = 1245,
        ApplicationCacheManifestSelectSecureOrigin = 1246,
        ApplicationCacheAPIInsecureOrigin = 1247,
        ApplicationCacheAPISecureOrigin = 1248,
        // The above items are available in M50 branch

        CSSAtRuleApply = 1249,
        CSSSelectorPseudoAny = 1250,
        PannerNodeSetVelocity = 1251,
        DocumentAllItemNoArguments = 1252,
        DocumentAllItemNamed = 1253,
        DocumentAllItemIndexed = 1254,
        DocumentAllItemIndexedWithNonNumber = 1255,
        DocumentAllLegacyCallNoArguments = 1256,
        DocumentAllLegacyCallNamed = 1257,
        DocumentAllLegacyCallIndexed = 1258,
        DocumentAllLegacyCallIndexedWithNonNumber = 1259,
        DocumentAllLegacyCallTwoArguments = 1260,
        HTMLLabelElementControlForNonFormAssociatedElement = 1263,
        HTMLMediaElementLoadNetworkEmptyNotPaused = 1265,
        V8Window_WebkitSpeechGrammar_ConstructorGetter = 1267,
        V8Window_WebkitSpeechGrammarList_ConstructorGetter = 1268,
        V8Window_WebkitSpeechRecognition_ConstructorGetter = 1269,
        V8Window_WebkitSpeechRecognitionError_ConstructorGetter = 1270,
        V8Window_WebkitSpeechRecognitionEvent_ConstructorGetter = 1271,
        V8Window_SpeechSynthesis_AttributeGetter = 1272,
        V8IDBFactory_WebkitGetDatabaseNames_Method = 1273,
        ImageDocument = 1274,
        ScriptPassesCSPDynamic = 1275,
        ScriptPassesCSPNonce = 1276,
        CSPWithStrictDynamic = 1277,
        ScrollAnchored = 1278,
        AddEventListenerFourArguments = 1279,
        RemoveEventListenerFourArguments = 1280,
        InvalidReportUriDirectiveInMetaCSP = 1281,
        InvalidSandboxDirectiveInMetaCSP = 1282,
        InvalidFrameAncestorsDirectiveInMetaCSP = 1283,
        DocumentCreateEventForeignFetchEvent = 1286,
        SVGCalcModeDiscrete = 1287,
        SVGCalcModeLinear = 1288,
        SVGCalcModePaced = 1289,
        SVGCalcModeSpline = 1290,
        FormSubmissionStarted = 1291,
        FormValidationStarted = 1292,
        FormValidationAbortedSubmission = 1293,
        FormValidationShowedMessage = 1294,
        WebAnimationsEasingAsFunctionLinear = 1295,
        WebAnimationsEasingAsFunctionOther = 1296,
        // The above items are available in M51 branch

        V8Document_Images_AttributeGetter = 1297,
        V8Document_Embeds_AttributeGetter = 1298,
        V8Document_Plugins_AttributeGetter = 1299,
        V8Document_Links_AttributeGetter = 1300,
        V8Document_Forms_AttributeGetter = 1301,
        V8Document_Scripts_AttributeGetter = 1302,
        V8Document_Anchors_AttributeGetter = 1303,
        V8Document_Applets_AttributeGetter = 1304,
        XMLHttpRequestCrossOriginWithCredentials = 1305,
        MediaStreamTrackRemote = 1306,
        V8Node_IsConnected_AttributeGetter = 1307,
        ShadowRootDelegatesFocus = 1308,
        MixedShadowRootV0AndV1 = 1309,
        ImageDocumentInFrame = 1310,
        MediaDocument = 1311,
        MediaDocumentInFrame = 1312,
        PluginDocument = 1313,
        PluginDocumentInFrame = 1314,
        SinkDocument = 1315,
        SinkDocumentInFrame = 1316,
        TextDocument = 1317,
        TextDocumentInFrame = 1318,
        ViewSourceDocument = 1319,
        FileAPINativeLineEndings = 1320,
        PointerEventAttributeCount = 1321,
        CompositedReplication = 1322,
        EncryptedMediaAllSelectedContentTypesHaveCodecs = 1323,
        EncryptedMediaAllSelectedContentTypesMissingCodecs = 1324,
        V8DataTransferItem_WebkitGetAsEntry_Method = 1325,
        V8HTMLInputElement_WebkitEntries_AttributeGetter = 1326,
        Entry_Filesystem_AttributeGetter_IsolatedFileSystem = 1327,
        Entry_GetMetadata_Method_IsolatedFileSystem = 1328,
        Entry_MoveTo_Method_IsolatedFileSystem = 1329,
        Entry_CopyTo_Method_IsolatedFileSystem = 1330,
        Entry_Remove_Method_IsolatedFileSystem = 1331,
        Entry_GetParent_Method_IsolatedFileSystem = 1332,
        Entry_ToURL_Method_IsolatedFileSystem = 1333,
        During_Microtask_Alert = 1334,
        During_Microtask_Confirm = 1335,
        During_Microtask_Print = 1336,
        During_Microtask_Prompt = 1337,
        During_Microtask_SyncXHR = 1338,
        URLMethodCreateObjectURLServiceWorker = 1339,
        URLMethodRevokeObjectURLServiceWorker = 1340,
        DocumentCreateEventPaymentRequestUpdateEvent = 1341,
        CredentialManagerGetReturnedCredential = 1342,
        GeolocationInsecureOriginDeprecatedNotRemoved = 1343,
        GeolocationInsecureOriginIframeDeprecatedNotRemoved = 1344,
        ProgressElementWithNoneAppearance = 1345,
        ProgressElementWithProgressBarAppearance = 1346,
        PointerEventAddListenerCount = 1347,
        EventCancelBubbleAffected = 1348,
        EventCancelBubbleWasChangedToTrue = 1349,
        EventCancelBubbleWasChangedToFalse = 1350,
        CSSValueAppearanceNone = 1351,
        CSSValueAppearanceNotNone = 1352,
        CSSValueAppearanceOthers = 1353,
        CSSValueAppearanceButton = 1354,
        CSSValueAppearanceCaret = 1355,
        CSSValueAppearanceCheckbox = 1356,
        CSSValueAppearanceMenulist = 1357,
        CSSValueAppearanceMenulistButton = 1358,
        CSSValueAppearanceListbox = 1359,
        CSSValueAppearanceRadio = 1360,
        CSSValueAppearanceSearchField = 1361,
        CSSValueAppearanceTextField = 1362,
        AudioContextCreatePannerAutomated = 1363,
        PannerNodeSetPosition = 1364,
        PannerNodeSetOrientation = 1365,
        AudioListenerSetPosition = 1366,
        AudioListenerSetOrientation = 1367,
        IntersectionObserver_Constructor = 1368,
        DurableStoragePersist = 1369,
        DurableStoragePersisted = 1370,
        DurableStorageEstimate = 1371,
        UntrustedEventDefaultHandled = 1372,
        // The following two items (FixedRasterScale*) are unused.
        FixedRasterScaleBlurryContent = 1373,
        FixedRasterScalePotentialPerformanceRegression = 1374,
        CSSDeepCombinatorAndShadow = 1375,
        OpacityWithPreserve3DQuirk = 1376,
        CSSSelectorPseudoReadOnly = 1377,
        CSSSelectorPseudoReadWrite = 1378,
        // The above items are available in M52 branch

        UnloadHandler_Navigation = 1379,
        TouchStartUserGestureUtilized = 1380,
        TouchMoveUserGestureUtilized = 1381,
        TouchEndDuringScrollUserGestureUtilized = 1382,
        CSSSelectorPseudoDefined = 1383,
        RTCPeerConnectionAddIceCandidatePromise = 1384,
        RTCPeerConnectionAddIceCandidateLegacy = 1385,
        RTCIceCandidateDefaultSdpMLineIndex = 1386,
        DocumentCreateEventSensorErrorEvent = 1387,
        DocumentCreateEventSensorReadingEvent = 1388,
        MediaStreamConstraintsOldAndNew = 1389,
        V8ArrayProtectorDirtied = 1390,
        V8ArraySpeciesModified = 1391,
        V8ArrayPrototypeConstructorModified = 1392,
        V8ArrayInstanceProtoModified = 1393,
        V8ArrayInstanceConstructorModified = 1394,
        V8LegacyFunctionDeclaration = 1395,
        V8RegExpPrototypeSourceGetter = 1396,
        V8RegExpPrototypeOldFlagGetter = 1397,
        V8DecimalWithLeadingZeroInStrictMode = 1398,
        FormSubmissionNotInDocumentTree = 1399,
        GetUserMediaPrefixed = 1400,
        GetUserMediaLegacy = 1401,
        GetUserMediaPromise = 1402,
        CSSFilterFunctionNoArguments = 1403,
        V8LegacyDateParser = 1404,
        OpenSearchInsecureOriginInsecureTarget = 1405,
        OpenSearchInsecureOriginSecureTarget = 1406,
        OpenSearchSecureOriginInsecureTarget = 1407,
        OpenSearchSecureOriginSecureTarget = 1408,
        RegisterProtocolHandlerSecureOrigin = 1409,
        RegisterProtocolHandlerInsecureOrigin = 1410,
        CrossOriginWindowAlert = 1411,
        CrossOriginWindowConfirm = 1412,
        CrossOriginWindowPrompt = 1413,
        CrossOriginWindowPrint = 1414,
        MediaStreamOnActive = 1415,
        MediaStreamOnInactive = 1416,
        AddEventListenerPassiveTrue = 1417,
        AddEventListenerPassiveFalse = 1418,
        CSPReferrerDirective = 1419,
        DocumentOpen = 1420,
        ElementRequestPointerLockInShadow = 1421,
        ShadowRootPointerLockElement = 1422,
        DocumentPointerLockElementInV0Shadow = 1423,
        TextAreaMaxLength = 1424,
        TextAreaMinLength = 1425,
        TopNavigationFromSubFrame = 1426,
        PrefixedElementRequestFullscreenInShadow = 1427,
        MediaSourceAbortRemove = 1428,
        MediaSourceDurationTruncatingBuffered = 1429,
        AudioContextCrossOriginIframe = 1430,
        CSSValueAppearanceButtonRendered = 1469,
        CSSValueAppearanceButtonForAnchor = 1470,
        CSSValueAppearanceButtonForButton = 1471,
        CSSValueAppearanceButtonForOtherButtons = 1472,
        CSSValueAppearanceTextFieldRendered = 1473,
        CSSValueAppearanceTextFieldForSearch = 1474,
        CSSValueAppearanceTextFieldForTextField = 1475,
        RTCPeerConnectionGetStats = 1476,
        SVGSMILAnimationAppliedEffect = 1477,
        PerformanceResourceTimingSizes = 1478,
        EventSourceDocument = 1479,
        EventSourceWorker = 1480,

        // Add new features immediately above this line. Don't change assigned
        // numbers of any item, and don't reuse removed slots.
        // Also, run update_use_counter_feature_enum.py in chromium/src/tools/metrics/histograms/
        // to update the UMA mapping.
        NumberOfFeatures, // This enum value must be last.
    };

    // "count" sets the bit for this feature to 1. Repeated calls are ignored.
    static void count(const Frame*, Feature);
    static void count(const Document&, Feature);
    // This doesn't count for ExecutionContexts for shared workers and service
    // workers.
    static void count(const ExecutionContext*, Feature);
    // Use countIfNotPrivateScript() instead of count() if you don't want
    // to count metrics in private scripts. You should use
    // countIfNotPrivateScript() in a binding layer.
    static void countIfNotPrivateScript(v8::Isolate*, const Frame*, Feature);
    static void countIfNotPrivateScript(v8::Isolate*, const Document&, Feature);
    static void countIfNotPrivateScript(v8::Isolate*, const ExecutionContext*, Feature);

    void count(CSSParserMode, CSSPropertyID);
    void count(Feature);

    // Count only features if they're being used in an iframe which does not
    // have script access into the top level document.
    static void countCrossOriginIframe(const Document&, Feature);

    // Return whether the Feature was previously counted for this document.
    // NOTE: only for use in testing.
    static bool isCounted(Document&, Feature);
    // Return whether the CSSPropertyID was previously counted for this document.
    // NOTE: only for use in testing.
    static bool isCounted(Document&, const String&);
    bool isCounted(CSSPropertyID unresolvedProperty);

    void didCommitLoad();

    static UseCounter* getFrom(const Document*);
    static UseCounter* getFrom(const CSSStyleSheet*);
    static UseCounter* getFrom(const StyleSheetContents*);

    static int mapCSSPropertyIdToCSSSampleIdForHistogram(int id);

    static void muteForInspector();
    static void unmuteForInspector();

    void recordMeasurement(Feature feature) { m_countBits.recordMeasurement(feature); }
    void updateMeasurements();

    bool hasRecordedMeasurement(Feature feature) const { return m_countBits.hasRecordedMeasurement(feature); }

    class CountBits {
        DISALLOW_NEW();
    public:
        CountBits() : m_bits(NumberOfFeatures) { }

        bool hasRecordedMeasurement(Feature feature) const
        {
            if (UseCounter::m_muteCount)
                return false;
            ASSERT(feature != PageDestruction); // PageDestruction is reserved as a scaling factor.
            ASSERT(feature < NumberOfFeatures);

            return m_bits.quickGet(feature);
        }

        void recordMeasurement(Feature feature)
        {
            if (UseCounter::m_muteCount)
                return;
            ASSERT(feature != PageDestruction); // PageDestruction is reserved as a scaling factor.
            ASSERT(feature < NumberOfFeatures);

            m_bits.quickSet(feature);
        }

        void updateMeasurements();

    private:
        BitVector m_bits;
    };

protected:
    friend class UseCounterTest;
    static int m_muteCount;

    CountBits m_countBits;
    BitVector m_CSSFeatureBits;
};

} // namespace blink

#endif // UseCounter_h
