// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only
import QtQuick 2.15
import HelperWidgets 2.0

ComboBox {
    id: comboBox

    property alias typeFilter: itemFilterModel.typeFilter

    manualMapping: true
    editable: true
    model: comboBox.addDefaultItem(itemFilterModel.itemModel)

    textInput.validator: RegularExpressionValidator { regularExpression: /(^$|^[a-z_]\w*)/ }

    ItemFilterModel {
        id: itemFilterModel
        modelNodeBackendProperty: modelNodeBackend
    }

    property string defaultItem: qsTr("None")
    property string textValue: comboBox.backendValue.expression
    property bool block: false
    property bool dirty: true
    property var editRegExp: /^[a-z_]\w*/

    onTextValueChanged: {
        if (comboBox.block)
            return

        comboBox.setCurrentText(comboBox.textValue)
    }
    onModelChanged: comboBox.setCurrentText(comboBox.textValue)
    onCompressedActivated: function(index, reason) { comboBox.handleActivate(index) }
    Component.onCompleted: comboBox.setCurrentText(comboBox.textValue)

    onEditTextChanged: {
        comboBox.dirty = true
        colorLogic.errorState = !(editRegExp.exec(comboBox.editText) !== null
                                  || comboBox.editText === parenthesize(defaultItem))
    }
    onFocusChanged: {
        if (comboBox.dirty)
           comboBox.handleActivate(comboBox.currentIndex)
    }

    function handleActivate(index)
    {
        if (!comboBox.__isCompleted || comboBox.backendValue === undefined)
            return

        var cText = (index === -1) ? comboBox.editText : comboBox.textAt(index)
        comboBox.block = true
        comboBox.setCurrentText(cText)
        comboBox.block = false
    }

    function setCurrentText(text)
    {
        if (!comboBox.__isCompleted || comboBox.backendValue === undefined)
            return

        comboBox.currentIndex = comboBox.find(text)

        if (text === "") {
            comboBox.currentIndex = 0
            comboBox.editText = parenthesize(comboBox.defaultItem)
        } else {
            if (comboBox.currentIndex === -1)
                comboBox.editText = text
            else if (comboBox.currentIndex === 0)
                comboBox.editText = parenthesize(comboBox.defaultItem)
        }

        if (comboBox.currentIndex === 0) {
            comboBox.backendValue.resetValue()
        } else {
            if (comboBox.backendValue.expression !== comboBox.editText)
                comboBox.backendValue.expression = comboBox.editText
        }
        comboBox.dirty = false
    }

    function addDefaultItem(arr)
    {
        var copy = arr.slice()
        copy.unshift(parenthesize(comboBox.defaultItem))
        return copy
    }

    function parenthesize(value)
    {
        return "[" + value + "]"
    }
}
